/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzerWrapper;
import org.elasticsearch.common.collect.UpdateInPlaceMap;

public final class FieldNameAnalyzer
extends SimpleAnalyzerWrapper {
    private final UpdateInPlaceMap<String, Analyzer> analyzers;
    private final Analyzer defaultAnalyzer;

    public FieldNameAnalyzer(UpdateInPlaceMap<String, Analyzer> analyzers, Analyzer defaultAnalyzer) {
        this.analyzers = analyzers;
        this.defaultAnalyzer = defaultAnalyzer;
    }

    public UpdateInPlaceMap<String, Analyzer> analyzers() {
        return this.analyzers;
    }

    public Analyzer defaultAnalyzer() {
        return this.defaultAnalyzer;
    }

    protected Analyzer getWrappedAnalyzer(String fieldName) {
        return this.getAnalyzer(fieldName);
    }

    private Analyzer getAnalyzer(String name) {
        Analyzer analyzer = this.analyzers.get(name);
        if (analyzer != null) {
            return analyzer;
        }
        return this.defaultAnalyzer;
    }
}

