/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.CloseableComponent;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lucene.uid.Versions;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.deletionpolicy.SnapshotIndexCommit;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.FlushNotAllowedEngineException;
import org.elasticsearch.index.engine.Segment;
import org.elasticsearch.index.engine.SegmentsStats;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.shard.IndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;

public interface Engine
extends IndexShardComponent,
CloseableComponent {
    public static final String INDEX_CODEC = "index.codec";
    public static final ByteSizeValue INACTIVE_SHARD_INDEXING_BUFFER = ByteSizeValue.parseBytesSizeValue("500kb");

    public TimeValue defaultRefreshInterval();

    public void enableGcDeletes(boolean var1);

    public void updateIndexingBufferSize(ByteSizeValue var1);

    public void addFailedEngineListener(FailedEngineListener var1);

    public void start() throws EngineException;

    public void create(Create var1) throws EngineException;

    public void index(Index var1) throws EngineException;

    public void delete(Delete var1) throws EngineException;

    public void delete(DeleteByQuery var1) throws EngineException;

    public GetResult get(Get var1) throws EngineException;

    public Searcher acquireSearcher(String var1) throws EngineException;

    public SegmentsStats segmentsStats();

    public List<Segment> segments();

    public boolean refreshNeeded();

    public boolean possibleMergeNeeded();

    public void maybeMerge() throws EngineException;

    public void refresh(Refresh var1) throws EngineException;

    public void flush(Flush var1) throws EngineException, FlushNotAllowedEngineException;

    public void optimize(Optimize var1) throws EngineException;

    public SnapshotIndexCommit snapshotIndex() throws EngineException;

    public void recover(RecoveryHandler var1) throws EngineException;

    public void failEngine(String var1, Throwable var2);

    public static class GetResult {
        private final boolean exists;
        private final long version;
        private final Translog.Source source;
        private final Versions.DocIdAndVersion docIdAndVersion;
        private final Searcher searcher;
        public static final GetResult NOT_EXISTS = new GetResult(false, -1L, null);

        public GetResult(boolean exists, long version, @Nullable Translog.Source source) {
            this.source = source;
            this.exists = exists;
            this.version = version;
            this.docIdAndVersion = null;
            this.searcher = null;
        }

        public GetResult(Searcher searcher, Versions.DocIdAndVersion docIdAndVersion) {
            this.exists = true;
            this.source = null;
            this.version = docIdAndVersion.version;
            this.docIdAndVersion = docIdAndVersion;
            this.searcher = searcher;
        }

        public boolean exists() {
            return this.exists;
        }

        public long version() {
            return this.version;
        }

        @Nullable
        public Translog.Source source() {
            return this.source;
        }

        public Searcher searcher() {
            return this.searcher;
        }

        public Versions.DocIdAndVersion docIdAndVersion() {
            return this.docIdAndVersion;
        }

        public void release() {
            if (this.searcher != null) {
                this.searcher.close();
            }
        }
    }

    public static class Get {
        private final boolean realtime;
        private final Term uid;
        private boolean loadSource = true;
        private long version = -3L;
        private VersionType versionType = VersionType.INTERNAL;

        public Get(boolean realtime, Term uid) {
            this.realtime = realtime;
            this.uid = uid;
        }

        public boolean realtime() {
            return this.realtime;
        }

        public Term uid() {
            return this.uid;
        }

        public boolean loadSource() {
            return this.loadSource;
        }

        public Get loadSource(boolean loadSource) {
            this.loadSource = loadSource;
            return this;
        }

        public long version() {
            return this.version;
        }

        public Get version(long version) {
            this.version = version;
            return this;
        }

        public VersionType versionType() {
            return this.versionType;
        }

        public Get versionType(VersionType versionType) {
            this.versionType = versionType;
            return this;
        }
    }

    public static class DeleteByQuery {
        private final Query query;
        private final BytesReference source;
        private final String[] filteringAliases;
        private final Filter aliasFilter;
        private final String[] types;
        private final Filter parentFilter;
        private final Operation.Origin origin;
        private final long startTime;
        private long endTime;

        public DeleteByQuery(Query query, BytesReference source, @Nullable String[] filteringAliases, @Nullable Filter aliasFilter, Filter parentFilter, Operation.Origin origin, long startTime, String ... types) {
            this.query = query;
            this.source = source;
            this.types = types;
            this.filteringAliases = filteringAliases;
            this.aliasFilter = aliasFilter;
            this.parentFilter = parentFilter;
            this.startTime = startTime;
            this.origin = origin;
        }

        public Query query() {
            return this.query;
        }

        public BytesReference source() {
            return this.source;
        }

        public String[] types() {
            return this.types;
        }

        public String[] filteringAliases() {
            return this.filteringAliases;
        }

        public Filter aliasFilter() {
            return this.aliasFilter;
        }

        public boolean nested() {
            return this.parentFilter != null;
        }

        public Filter parentFilter() {
            return this.parentFilter;
        }

        public Operation.Origin origin() {
            return this.origin;
        }

        public long startTime() {
            return this.startTime;
        }

        public DeleteByQuery endTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        public long endTime() {
            return this.endTime;
        }
    }

    public static class Delete
    implements Operation {
        private final String type;
        private final String id;
        private final Term uid;
        private long version;
        private final VersionType versionType;
        private final Operation.Origin origin;
        private boolean found;
        private final long startTime;
        private long endTime;

        public Delete(String type, String id, Term uid, long version, VersionType versionType, Operation.Origin origin, long startTime, boolean found) {
            this.type = type;
            this.id = id;
            this.uid = uid;
            this.version = version;
            this.versionType = versionType;
            this.origin = origin;
            this.startTime = startTime;
            this.found = found;
        }

        public Delete(String type, String id, Term uid) {
            this(type, id, uid, -3L, VersionType.INTERNAL, Operation.Origin.PRIMARY, System.nanoTime(), false);
        }

        public Delete(Delete template, VersionType versionType) {
            this(template.type(), template.id(), template.uid(), template.version(), versionType, template.origin(), template.startTime(), template.found());
        }

        @Override
        public Operation.Type opType() {
            return Operation.Type.DELETE;
        }

        @Override
        public Operation.Origin origin() {
            return this.origin;
        }

        public String type() {
            return this.type;
        }

        public String id() {
            return this.id;
        }

        public Term uid() {
            return this.uid;
        }

        public void updateVersion(long version, boolean found) {
            this.version = version;
            this.found = found;
        }

        public long version() {
            return this.version;
        }

        public VersionType versionType() {
            return this.versionType;
        }

        public boolean found() {
            return this.found;
        }

        public long startTime() {
            return this.startTime;
        }

        public void endTime(long endTime) {
            this.endTime = endTime;
        }

        public long endTime() {
            return this.endTime;
        }
    }

    public static final class Index
    extends IndexingOperation {
        private boolean created;

        public Index(DocumentMapper docMapper, Term uid, ParsedDocument doc, long version, VersionType versionType, Operation.Origin origin, long startTime, boolean canHaveDuplicates) {
            super(docMapper, uid, doc, version, versionType, origin, startTime, canHaveDuplicates);
        }

        public Index(DocumentMapper docMapper, Term uid, ParsedDocument doc, long version, VersionType versionType, Operation.Origin origin, long startTime) {
            super(docMapper, uid, doc, version, versionType, origin, startTime, true);
        }

        public Index(DocumentMapper docMapper, Term uid, ParsedDocument doc) {
            super(docMapper, uid, doc);
        }

        @Override
        public Operation.Type opType() {
            return Operation.Type.INDEX;
        }

        public boolean created() {
            return this.created;
        }

        public void created(boolean created) {
            this.created = created;
        }
    }

    public static final class Create
    extends IndexingOperation {
        private final boolean autoGeneratedId;

        public Create(DocumentMapper docMapper, Term uid, ParsedDocument doc, long version, VersionType versionType, Operation.Origin origin, long startTime, boolean canHaveDuplicates, boolean autoGeneratedId) {
            super(docMapper, uid, doc, version, versionType, origin, startTime, canHaveDuplicates);
            this.autoGeneratedId = autoGeneratedId;
        }

        public Create(DocumentMapper docMapper, Term uid, ParsedDocument doc, long version, VersionType versionType, Operation.Origin origin, long startTime) {
            this(docMapper, uid, doc, version, versionType, origin, startTime, true, false);
        }

        public Create(DocumentMapper docMapper, Term uid, ParsedDocument doc) {
            super(docMapper, uid, doc);
            this.autoGeneratedId = false;
        }

        @Override
        public Operation.Type opType() {
            return Operation.Type.CREATE;
        }

        public boolean autoGeneratedId() {
            return this.autoGeneratedId;
        }
    }

    public static abstract class IndexingOperation
    implements Operation {
        private final DocumentMapper docMapper;
        private final Term uid;
        private final ParsedDocument doc;
        private long version;
        private final VersionType versionType;
        private final Operation.Origin origin;
        private final boolean canHaveDuplicates;
        private final long startTime;
        private long endTime;

        public IndexingOperation(DocumentMapper docMapper, Term uid, ParsedDocument doc, long version, VersionType versionType, Operation.Origin origin, long startTime, boolean canHaveDuplicates) {
            this.docMapper = docMapper;
            this.uid = uid;
            this.doc = doc;
            this.version = version;
            this.versionType = versionType;
            this.origin = origin;
            this.startTime = startTime;
            this.canHaveDuplicates = canHaveDuplicates;
        }

        public IndexingOperation(DocumentMapper docMapper, Term uid, ParsedDocument doc) {
            this(docMapper, uid, doc, -3L, VersionType.INTERNAL, Operation.Origin.PRIMARY, System.nanoTime(), true);
        }

        public DocumentMapper docMapper() {
            return this.docMapper;
        }

        @Override
        public Operation.Origin origin() {
            return this.origin;
        }

        public ParsedDocument parsedDoc() {
            return this.doc;
        }

        public Term uid() {
            return this.uid;
        }

        public String type() {
            return this.doc.type();
        }

        public String id() {
            return this.doc.id();
        }

        public String routing() {
            return this.doc.routing();
        }

        public long timestamp() {
            return this.doc.timestamp();
        }

        public long ttl() {
            return this.doc.ttl();
        }

        public long version() {
            return this.version;
        }

        public void updateVersion(long version) {
            this.version = version;
            this.doc.version().setLongValue(version);
        }

        public VersionType versionType() {
            return this.versionType;
        }

        public boolean canHaveDuplicates() {
            return this.canHaveDuplicates;
        }

        public String parent() {
            return this.doc.parent();
        }

        public List<ParseContext.Document> docs() {
            return this.doc.docs();
        }

        public Analyzer analyzer() {
            return this.doc.analyzer();
        }

        public BytesReference source() {
            return this.doc.source();
        }

        public long startTime() {
            return this.startTime;
        }

        public void endTime(long endTime) {
            this.endTime = endTime;
        }

        public long endTime() {
            return this.endTime;
        }
    }

    public static interface Operation {
        public Type opType();

        public Origin origin();

        public static enum Origin {
            PRIMARY,
            REPLICA,
            RECOVERY;

        }

        public static enum Type {
            CREATE,
            INDEX,
            DELETE;

        }
    }

    public static class Optimize {
        private boolean waitForMerge = true;
        private int maxNumSegments = -1;
        private boolean onlyExpungeDeletes = false;
        private boolean flush = false;
        private boolean force = false;

        public boolean waitForMerge() {
            return this.waitForMerge;
        }

        public Optimize waitForMerge(boolean waitForMerge) {
            this.waitForMerge = waitForMerge;
            return this;
        }

        public int maxNumSegments() {
            return this.maxNumSegments;
        }

        public Optimize maxNumSegments(int maxNumSegments) {
            this.maxNumSegments = maxNumSegments;
            return this;
        }

        public boolean onlyExpungeDeletes() {
            return this.onlyExpungeDeletes;
        }

        public Optimize onlyExpungeDeletes(boolean onlyExpungeDeletes) {
            this.onlyExpungeDeletes = onlyExpungeDeletes;
            return this;
        }

        public boolean flush() {
            return this.flush;
        }

        public Optimize flush(boolean flush) {
            this.flush = flush;
            return this;
        }

        public boolean force() {
            return this.force;
        }

        public Optimize force(boolean force) {
            this.force = force;
            return this;
        }

        public String toString() {
            return "waitForMerge[" + this.waitForMerge + "], maxNumSegments[" + this.maxNumSegments + "], onlyExpungeDeletes[" + this.onlyExpungeDeletes + "], flush[" + this.flush + "], force[" + this.force + "]";
        }
    }

    public static class Flush {
        private Type type = Type.COMMIT_TRANSLOG;
        private boolean force = false;
        private boolean waitIfOngoing = false;

        public Type type() {
            return this.type;
        }

        public Flush type(Type type) {
            this.type = type;
            return this;
        }

        public boolean force() {
            return this.force;
        }

        public Flush force(boolean force) {
            this.force = force;
            return this;
        }

        public boolean waitIfOngoing() {
            return this.waitIfOngoing;
        }

        public Flush waitIfOngoing(boolean waitIfOngoing) {
            this.waitIfOngoing = waitIfOngoing;
            return this;
        }

        public String toString() {
            return "type[" + (Object)((Object)this.type) + "], force[" + this.force + "]";
        }

        public static enum Type {
            NEW_WRITER,
            COMMIT,
            COMMIT_TRANSLOG;

        }
    }

    public static class Refresh {
        private final String source;
        private boolean force = false;

        public Refresh(String source) {
            this.source = source;
        }

        public Refresh force(boolean force) {
            this.force = force;
            return this;
        }

        public boolean force() {
            return this.force;
        }

        public String source() {
            return this.source;
        }

        public String toString() {
            return "force[" + this.force + "], source [" + this.source + "]";
        }
    }

    public static class SimpleSearcher
    implements Searcher {
        private final String source;
        private final IndexSearcher searcher;

        public SimpleSearcher(String source, IndexSearcher searcher) {
            this.source = source;
            this.searcher = searcher;
        }

        @Override
        public String source() {
            return this.source;
        }

        @Override
        public IndexReader reader() {
            return this.searcher.getIndexReader();
        }

        @Override
        public IndexSearcher searcher() {
            return this.searcher;
        }

        @Override
        public void close() throws ElasticsearchException {
        }
    }

    public static interface Searcher
    extends Releasable {
        public String source();

        public IndexReader reader();

        public IndexSearcher searcher();
    }

    public static interface RecoveryHandler {
        public void phase1(SnapshotIndexCommit var1) throws ElasticsearchException;

        public void phase2(Translog.Snapshot var1) throws ElasticsearchException;

        public void phase3(Translog.Snapshot var1) throws ElasticsearchException;
    }

    public static interface FailedEngineListener {
        public void onFailedEngine(ShardId var1, String var2, @Nullable Throwable var3);
    }
}

