/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.gateway;

import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.CloseableIndexComponent;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.gateway.IgnoreGatewayRecoveryException;
import org.elasticsearch.index.gateway.IndexShardGateway;
import org.elasticsearch.index.gateway.IndexShardGatewayRecoveryException;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.IndexShardNotStartedException;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.shard.service.InternalIndexShard;
import org.elasticsearch.index.snapshots.IndexShardSnapshotAndRestoreService;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.threadpool.ThreadPool;

public class IndexShardGatewayService
extends AbstractIndexShardComponent
implements CloseableIndexComponent {
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final InternalIndexShard indexShard;
    private final IndexShardGateway shardGateway;
    private final IndexShardSnapshotAndRestoreService snapshotService;
    private RecoveryState recoveryState;

    @Inject
    public IndexShardGatewayService(ShardId shardId, @IndexSettings Settings indexSettings, ThreadPool threadPool, IndexShard indexShard, IndexShardGateway shardGateway, IndexShardSnapshotAndRestoreService snapshotService, ClusterService clusterService) {
        super(shardId, indexSettings);
        this.threadPool = threadPool;
        this.indexShard = (InternalIndexShard)indexShard;
        this.shardGateway = shardGateway;
        this.snapshotService = snapshotService;
        this.recoveryState = new RecoveryState(shardId);
        this.clusterService = clusterService;
    }

    public void routingStateChanged() {
    }

    public RecoveryState recoveryState() {
        if (this.recoveryState.getTimer().startTime() > 0L && this.recoveryState.getStage() != RecoveryState.Stage.DONE) {
            this.recoveryState.getTimer().time(System.currentTimeMillis() - this.recoveryState.getTimer().startTime());
        }
        return this.recoveryState;
    }

    public void recover(final boolean indexShouldExists, final RecoveryListener listener) throws IndexShardGatewayRecoveryException, IgnoreGatewayRecoveryException {
        if (this.indexShard.state() == IndexShardState.CLOSED) {
            listener.onIgnoreRecovery("shard closed");
            return;
        }
        if (!this.indexShard.routingEntry().primary()) {
            listener.onRecoveryFailed(new IndexShardGatewayRecoveryException(this.shardId, "Trying to recover when the shard is in backup state", null));
            return;
        }
        try {
            if (this.indexShard.routingEntry().restoreSource() != null) {
                this.indexShard.recovering("from snapshot");
            } else {
                this.indexShard.recovering("from gateway");
            }
        }
        catch (IllegalIndexShardStateException e) {
            listener.onIgnoreRecovery("already in recovering process, " + e.getMessage());
            return;
        }
        this.threadPool.generic().execute(new Runnable(){

            @Override
            public void run() {
                IndexShardGatewayService.this.recoveryState.getTimer().startTime(System.currentTimeMillis());
                IndexShardGatewayService.this.recoveryState.setTargetNode(IndexShardGatewayService.this.clusterService.localNode());
                IndexShardGatewayService.this.recoveryState.setStage(RecoveryState.Stage.INIT);
                IndexShardGatewayService.this.recoveryState.setPrimary(IndexShardGatewayService.this.indexShard.routingEntry().primary());
                try {
                    if (IndexShardGatewayService.this.indexShard.routingEntry().restoreSource() != null) {
                        IndexShardGatewayService.this.logger.debug("restoring from {} ...", IndexShardGatewayService.this.indexShard.routingEntry().restoreSource());
                        IndexShardGatewayService.this.recoveryState.setType(RecoveryState.Type.SNAPSHOT);
                        IndexShardGatewayService.this.recoveryState.setRestoreSource(IndexShardGatewayService.this.indexShard.routingEntry().restoreSource());
                        IndexShardGatewayService.this.snapshotService.restore(IndexShardGatewayService.this.recoveryState);
                    } else {
                        IndexShardGatewayService.this.logger.debug("starting recovery from {} ...", IndexShardGatewayService.this.shardGateway);
                        IndexShardGatewayService.this.recoveryState.setType(RecoveryState.Type.GATEWAY);
                        IndexShardGatewayService.this.recoveryState.setSourceNode(IndexShardGatewayService.this.clusterService.localNode());
                        IndexShardGatewayService.this.shardGateway.recover(indexShouldExists, IndexShardGatewayService.this.recoveryState);
                    }
                    IndexShardState shardState = IndexShardGatewayService.this.indexShard.state();
                    if (shardState != IndexShardState.POST_RECOVERY && shardState != IndexShardState.STARTED) {
                        IndexShardGatewayService.this.indexShard.postRecovery("post recovery from gateway");
                    }
                    IndexShardGatewayService.this.indexShard.refresh(new Engine.Refresh("post_gateway").force(true));
                    IndexShardGatewayService.this.recoveryState.getTimer().time(System.currentTimeMillis() - IndexShardGatewayService.this.recoveryState.getTimer().startTime());
                    IndexShardGatewayService.this.recoveryState.setStage(RecoveryState.Stage.DONE);
                    if (IndexShardGatewayService.this.logger.isTraceEnabled()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("recovery completed from ").append(IndexShardGatewayService.this.shardGateway).append(", took [").append(TimeValue.timeValueMillis(IndexShardGatewayService.this.recoveryState.getTimer().time())).append("]\n");
                        sb.append("    index    : files           [").append(IndexShardGatewayService.this.recoveryState.getIndex().totalFileCount()).append("] with total_size [").append(new ByteSizeValue(IndexShardGatewayService.this.recoveryState.getIndex().totalByteCount())).append("], took[").append(TimeValue.timeValueMillis(IndexShardGatewayService.this.recoveryState.getIndex().time())).append("]\n");
                        sb.append("             : recovered_files [").append(IndexShardGatewayService.this.recoveryState.getIndex().numberOfRecoveredFiles()).append("] with total_size [").append(new ByteSizeValue(IndexShardGatewayService.this.recoveryState.getIndex().recoveredTotalSize())).append("]\n");
                        sb.append("             : reusing_files   [").append(IndexShardGatewayService.this.recoveryState.getIndex().reusedFileCount()).append("] with total_size [").append(new ByteSizeValue(IndexShardGatewayService.this.recoveryState.getIndex().reusedByteCount())).append("]\n");
                        sb.append("    start    : took [").append(TimeValue.timeValueMillis(IndexShardGatewayService.this.recoveryState.getStart().time())).append("], check_index [").append(TimeValue.timeValueMillis(IndexShardGatewayService.this.recoveryState.getStart().checkIndexTime())).append("]\n");
                        sb.append("    translog : number_of_operations [").append(IndexShardGatewayService.this.recoveryState.getTranslog().currentTranslogOperations()).append("], took [").append(TimeValue.timeValueMillis(IndexShardGatewayService.this.recoveryState.getTranslog().time())).append("]");
                        IndexShardGatewayService.this.logger.trace(sb.toString(), new Object[0]);
                    } else if (IndexShardGatewayService.this.logger.isDebugEnabled()) {
                        IndexShardGatewayService.this.logger.debug("recovery completed from [{}], took [{}]", IndexShardGatewayService.this.shardGateway, TimeValue.timeValueMillis(IndexShardGatewayService.this.recoveryState.getTimer().time()));
                    }
                    listener.onRecoveryDone();
                }
                catch (IndexShardGatewayRecoveryException e) {
                    if (IndexShardGatewayService.this.indexShard.state() == IndexShardState.CLOSED) {
                        listener.onIgnoreRecovery("shard closed");
                        return;
                    }
                    if (e.getCause() instanceof IndexShardClosedException || e.getCause() instanceof IndexShardNotStartedException) {
                        listener.onIgnoreRecovery("shard closed");
                        return;
                    }
                    listener.onRecoveryFailed(e);
                }
                catch (IndexShardClosedException e) {
                    listener.onIgnoreRecovery("shard closed");
                }
                catch (IndexShardNotStartedException e) {
                    listener.onIgnoreRecovery("shard closed");
                }
                catch (Exception e) {
                    if (IndexShardGatewayService.this.indexShard.state() == IndexShardState.CLOSED) {
                        listener.onIgnoreRecovery("shard closed");
                        return;
                    }
                    listener.onRecoveryFailed(new IndexShardGatewayRecoveryException(IndexShardGatewayService.this.shardId, "failed recovery", (Throwable)e));
                }
            }
        });
    }

    @Override
    public synchronized void close() {
        this.shardGateway.close();
    }

    public static interface RecoveryListener {
        public void onRecoveryDone();

        public void onIgnoreRecovery(String var1);

        public void onRecoveryFailed(IndexShardGatewayRecoveryException var1);
    }
}

