/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.geo;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.lucene.docset.AndDocIdSet;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.lucene.docset.MatchDocIdSet;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.mapper.geo.GeoPointFieldMapper;
import org.elasticsearch.index.search.geo.IndexedGeoBoundingBoxFilter;

public class GeoDistanceFilter
extends Filter {
    private final double lat;
    private final double lon;
    private final double distance;
    private final GeoDistance geoDistance;
    private final IndexGeoPointFieldData indexFieldData;
    private final GeoDistance.FixedSourceDistance fixedSourceDistance;
    private final GeoDistance.DistanceBoundingCheck distanceBoundingCheck;
    private final Filter boundingBoxFilter;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GeoDistanceFilter(double lat, double lon, double distance, GeoDistance geoDistance, IndexGeoPointFieldData indexFieldData, GeoPointFieldMapper mapper, String optimizeBbox) {
        this.lat = lat;
        this.lon = lon;
        this.distance = distance;
        this.geoDistance = geoDistance;
        this.indexFieldData = indexFieldData;
        this.fixedSourceDistance = geoDistance.fixedSourceDistance(lat, lon, DistanceUnit.DEFAULT);
        GeoDistance.DistanceBoundingCheck distanceBoundingCheck = null;
        if (optimizeBbox != null && !"none".equals(optimizeBbox)) {
            distanceBoundingCheck = GeoDistance.distanceBoundingCheck(lat, lon, distance, DistanceUnit.DEFAULT);
            if ("memory".equals(optimizeBbox)) {
                this.boundingBoxFilter = null;
            } else {
                if (!"indexed".equals(optimizeBbox)) throw new ElasticsearchIllegalArgumentException("type [" + optimizeBbox + "] for bounding box optimization not supported");
                this.boundingBoxFilter = IndexedGeoBoundingBoxFilter.create(distanceBoundingCheck.topLeft(), distanceBoundingCheck.bottomRight(), mapper);
                distanceBoundingCheck = GeoDistance.ALWAYS_INSTANCE;
            }
        } else {
            distanceBoundingCheck = GeoDistance.ALWAYS_INSTANCE;
            this.boundingBoxFilter = null;
        }
        this.distanceBoundingCheck = distanceBoundingCheck;
    }

    public double lat() {
        return this.lat;
    }

    public double lon() {
        return this.lon;
    }

    public double distance() {
        return this.distance;
    }

    public GeoDistance geoDistance() {
        return this.geoDistance;
    }

    public String fieldName() {
        return this.indexFieldData.getFieldNames().indexName();
    }

    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptedDocs) throws IOException {
        DocIdSet boundingBoxDocSet = null;
        if (this.boundingBoxFilter != null && DocIdSets.isEmpty(boundingBoxDocSet = this.boundingBoxFilter.getDocIdSet(context, acceptedDocs))) {
            return null;
        }
        GeoPointValues values = ((AtomicGeoPointFieldData)this.indexFieldData.load(context)).getGeoPointValues();
        GeoDistanceDocSet distDocSet = new GeoDistanceDocSet(context.reader().maxDoc(), acceptedDocs, values, this.fixedSourceDistance, this.distanceBoundingCheck, this.distance);
        if (boundingBoxDocSet == null) {
            return distDocSet;
        }
        return new AndDocIdSet(new DocIdSet[]{boundingBoxDocSet, distDocSet});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GeoDistanceFilter filter = (GeoDistanceFilter)((Object)o);
        if (Double.compare(filter.distance, this.distance) != 0) {
            return false;
        }
        if (Double.compare(filter.lat, this.lat) != 0) {
            return false;
        }
        if (Double.compare(filter.lon, this.lon) != 0) {
            return false;
        }
        if (!this.indexFieldData.getFieldNames().indexName().equals(filter.indexFieldData.getFieldNames().indexName())) {
            return false;
        }
        return this.geoDistance == filter.geoDistance;
    }

    public String toString() {
        return "GeoDistanceFilter(" + this.indexFieldData.getFieldNames().indexName() + ", " + (Object)((Object)this.geoDistance) + ", " + this.distance + ", " + this.lat + ", " + this.lon + ")";
    }

    public int hashCode() {
        long temp = this.lat != 0.0 ? Double.doubleToLongBits(this.lat) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.lon != 0.0 ? Double.doubleToLongBits(this.lon) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.distance != 0.0 ? Double.doubleToLongBits(this.distance) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.geoDistance != null ? this.geoDistance.hashCode() : 0);
        result = 31 * result + this.indexFieldData.getFieldNames().indexName().hashCode();
        return result;
    }

    public static class GeoDistanceDocSet
    extends MatchDocIdSet {
        private final double distance;
        private final GeoPointValues values;
        private final GeoDistance.FixedSourceDistance fixedSourceDistance;
        private final GeoDistance.DistanceBoundingCheck distanceBoundingCheck;

        public GeoDistanceDocSet(int maxDoc, @Nullable Bits acceptDocs, GeoPointValues values, GeoDistance.FixedSourceDistance fixedSourceDistance, GeoDistance.DistanceBoundingCheck distanceBoundingCheck, double distance) {
            super(maxDoc, acceptDocs);
            this.values = values;
            this.fixedSourceDistance = fixedSourceDistance;
            this.distanceBoundingCheck = distanceBoundingCheck;
            this.distance = distance;
        }

        @Override
        protected boolean matchDoc(int doc) {
            int length = this.values.setDocument(doc);
            for (int i = 0; i < length; ++i) {
                double d;
                GeoPoint point = this.values.nextValue();
                if (!this.distanceBoundingCheck.isWithin(point.lat(), point.lon()) || !((d = this.fixedSourceDistance.calculate(point.lat(), point.lon())) < this.distance)) continue;
                return true;
            }
            return false;
        }
    }
}

