/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.snapshots.blobstore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.util.Version;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.store.StoreFileMetaData;

public class BlobStoreIndexShardSnapshot {
    private final String snapshot;
    private final long indexVersion;
    private final long startTime;
    private final long time;
    private final int numberOfFiles;
    private final long totalSize;
    private final ImmutableList<FileInfo> indexFiles;

    public BlobStoreIndexShardSnapshot(String snapshot, long indexVersion, List<FileInfo> indexFiles, long startTime, long time, int numberOfFiles, long totalSize) {
        assert (snapshot != null);
        assert (indexVersion >= 0L);
        this.snapshot = snapshot;
        this.indexVersion = indexVersion;
        this.indexFiles = ImmutableList.copyOf(indexFiles);
        this.startTime = startTime;
        this.time = time;
        this.numberOfFiles = numberOfFiles;
        this.totalSize = totalSize;
    }

    public long indexVersion() {
        return this.indexVersion;
    }

    public String snapshot() {
        return this.snapshot;
    }

    public ImmutableList<FileInfo> indexFiles() {
        return this.indexFiles;
    }

    public long startTime() {
        return this.startTime;
    }

    public long time() {
        return this.time;
    }

    public int numberOfFiles() {
        return this.numberOfFiles;
    }

    public long totalSize() {
        return this.totalSize;
    }

    public static void toXContent(BlobStoreIndexShardSnapshot snapshot, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Fields.NAME, snapshot.snapshot);
        builder.field(Fields.INDEX_VERSION, snapshot.indexVersion);
        builder.field(Fields.START_TIME, snapshot.startTime);
        builder.field(Fields.TIME, snapshot.time);
        builder.field(Fields.NUMBER_OF_FILES, snapshot.numberOfFiles);
        builder.field(Fields.TOTAL_SIZE, snapshot.totalSize);
        builder.startArray(Fields.FILES);
        for (FileInfo fileInfo : snapshot.indexFiles) {
            FileInfo.toXContent(fileInfo, builder, params);
        }
        builder.endArray();
        builder.endObject();
    }

    public static BlobStoreIndexShardSnapshot fromXContent(XContentParser parser) throws IOException {
        String snapshot = null;
        long indexVersion = -1L;
        long startTime = 0L;
        long time = 0L;
        int numberOfFiles = 0;
        long totalSize = 0L;
        ArrayList<FileInfo> indexFiles = Lists.newArrayList();
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.START_OBJECT) {
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    String currentFieldName = parser.currentName();
                    token = parser.nextToken();
                    if (token.isValue()) {
                        if (ParseFields.NAME.match(currentFieldName)) {
                            snapshot = parser.text();
                            continue;
                        }
                        if (ParseFields.INDEX_VERSION.match(currentFieldName)) {
                            indexVersion = parser.longValue();
                            continue;
                        }
                        if (ParseFields.START_TIME.match(currentFieldName)) {
                            startTime = parser.longValue();
                            continue;
                        }
                        if (ParseFields.TIME.match(currentFieldName)) {
                            time = parser.longValue();
                            continue;
                        }
                        if (ParseFields.NUMBER_OF_FILES.match(currentFieldName)) {
                            numberOfFiles = parser.intValue();
                            continue;
                        }
                        if (ParseFields.TOTAL_SIZE.match(currentFieldName)) {
                            totalSize = parser.longValue();
                            continue;
                        }
                        throw new ElasticsearchParseException("unknown parameter [" + currentFieldName + "]");
                    }
                    if (token == XContentParser.Token.START_ARRAY) {
                        if (ParseFields.FILES.match(currentFieldName)) {
                            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                                indexFiles.add(FileInfo.fromXContent(parser));
                            }
                            continue;
                        }
                        throw new ElasticsearchParseException("unknown parameter [" + currentFieldName + "]");
                    }
                    throw new ElasticsearchParseException("unexpected token  [" + (Object)((Object)token) + "]");
                }
                throw new ElasticsearchParseException("unexpected token  [" + (Object)((Object)token) + "]");
            }
        }
        return new BlobStoreIndexShardSnapshot(snapshot, indexVersion, ImmutableList.copyOf(indexFiles), startTime, time, numberOfFiles, totalSize);
    }

    public boolean containPhysicalIndexFile(String physicalName) {
        return this.findPhysicalIndexFile(physicalName) != null;
    }

    public FileInfo findPhysicalIndexFile(String physicalName) {
        for (FileInfo file : this.indexFiles) {
            if (!file.physicalName().equals(physicalName)) continue;
            return file;
        }
        return null;
    }

    public FileInfo findNameFile(String name) {
        for (FileInfo file : this.indexFiles) {
            if (!file.name().equals(name)) continue;
            return file;
        }
        return null;
    }

    static final class ParseFields {
        static final ParseField NAME = new ParseField("name", new String[0]);
        static final ParseField INDEX_VERSION = new ParseField("index_version", "index-version");
        static final ParseField START_TIME = new ParseField("start_time", new String[0]);
        static final ParseField TIME = new ParseField("time", new String[0]);
        static final ParseField NUMBER_OF_FILES = new ParseField("number_of_files", new String[0]);
        static final ParseField TOTAL_SIZE = new ParseField("total_size", new String[0]);
        static final ParseField FILES = new ParseField("files", new String[0]);

        ParseFields() {
        }
    }

    static final class Fields {
        static final XContentBuilderString NAME = new XContentBuilderString("name");
        static final XContentBuilderString INDEX_VERSION = new XContentBuilderString("index_version");
        static final XContentBuilderString START_TIME = new XContentBuilderString("start_time");
        static final XContentBuilderString TIME = new XContentBuilderString("time");
        static final XContentBuilderString NUMBER_OF_FILES = new XContentBuilderString("number_of_files");
        static final XContentBuilderString TOTAL_SIZE = new XContentBuilderString("total_size");
        static final XContentBuilderString FILES = new XContentBuilderString("files");

        Fields() {
        }
    }

    public static class FileInfo {
        private final String name;
        private final ByteSizeValue partSize;
        private final long partBytes;
        private final long numberOfParts;
        private final StoreFileMetaData metadata;

        public FileInfo(String name, StoreFileMetaData metaData, ByteSizeValue partSize) {
            this.name = name;
            this.metadata = metaData;
            long partBytes = Long.MAX_VALUE;
            if (partSize != null) {
                partBytes = partSize.bytes();
            }
            long totalLength = metaData.length();
            long numberOfParts = totalLength / partBytes;
            if (totalLength % partBytes > 0L) {
                ++numberOfParts;
            }
            if (numberOfParts == 0L) {
                ++numberOfParts;
            }
            this.numberOfParts = numberOfParts;
            this.partSize = partSize;
            this.partBytes = partBytes;
        }

        public String name() {
            return this.name;
        }

        public String partName(long part) {
            if (this.numberOfParts > 1L) {
                return this.name + ".part" + part;
            }
            return this.name;
        }

        public static String canonicalName(String blobName) {
            if (blobName.contains(".part")) {
                return blobName.substring(0, blobName.indexOf(".part"));
            }
            return blobName;
        }

        public String physicalName() {
            return this.metadata.name();
        }

        public long length() {
            return this.metadata.length();
        }

        public ByteSizeValue partSize() {
            return this.partSize;
        }

        public long partBytes() {
            return this.partBytes;
        }

        public long numberOfParts() {
            return this.numberOfParts;
        }

        @Nullable
        public String checksum() {
            return this.metadata.checksum();
        }

        public StoreFileMetaData metadata() {
            return this.metadata;
        }

        public boolean isSame(StoreFileMetaData md) {
            return this.metadata.isSame(md);
        }

        public static void toXContent(FileInfo file, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Fields.NAME, file.name);
            builder.field(Fields.PHYSICAL_NAME, file.metadata.name());
            builder.field(Fields.LENGTH, file.metadata.length());
            if (file.metadata.checksum() != null) {
                builder.field(Fields.CHECKSUM, file.metadata.checksum());
            }
            if (file.partSize != null) {
                builder.field(Fields.PART_SIZE, file.partSize.bytes());
            }
            if (file.metadata.writtenBy() != null) {
                builder.field(Fields.WRITTEN_BY, (Object)file.metadata.writtenBy());
            }
            builder.endObject();
        }

        public static FileInfo fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.currentToken();
            String name = null;
            String physicalName = null;
            long length = -1L;
            String checksum = null;
            ByteSizeValue partSize = null;
            Version writtenBy = null;
            if (token == XContentParser.Token.START_OBJECT) {
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        String currentFieldName = parser.currentName();
                        token = parser.nextToken();
                        if (token.isValue()) {
                            if ("name".equals(currentFieldName)) {
                                name = parser.text();
                                continue;
                            }
                            if ("physical_name".equals(currentFieldName)) {
                                physicalName = parser.text();
                                continue;
                            }
                            if ("length".equals(currentFieldName)) {
                                length = parser.longValue();
                                continue;
                            }
                            if ("checksum".equals(currentFieldName)) {
                                checksum = parser.text();
                                continue;
                            }
                            if ("part_size".equals(currentFieldName)) {
                                partSize = new ByteSizeValue(parser.longValue());
                                continue;
                            }
                            if ("written_by".equals(currentFieldName)) {
                                writtenBy = Lucene.parseVersionLenient(parser.text(), null);
                                continue;
                            }
                            throw new ElasticsearchParseException("unknown parameter [" + currentFieldName + "]");
                        }
                        throw new ElasticsearchParseException("unexpected token  [" + (Object)((Object)token) + "]");
                    }
                    throw new ElasticsearchParseException("unexpected token  [" + (Object)((Object)token) + "]");
                }
            }
            return new FileInfo(name, new StoreFileMetaData(physicalName, length, checksum, writtenBy), partSize);
        }

        static final class Fields {
            static final XContentBuilderString NAME = new XContentBuilderString("name");
            static final XContentBuilderString PHYSICAL_NAME = new XContentBuilderString("physical_name");
            static final XContentBuilderString LENGTH = new XContentBuilderString("length");
            static final XContentBuilderString CHECKSUM = new XContentBuilderString("checksum");
            static final XContentBuilderString PART_SIZE = new XContentBuilderString("part_size");
            static final XContentBuilderString WRITTEN_BY = new XContentBuilderString("written_by");

            Fields() {
            }
        }
    }
}

