/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.cat;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Table;
import org.elasticsearch.common.hppc.ObjectLongMap;
import org.elasticsearch.common.hppc.ObjectLongOpenHashMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.action.cat.AbstractCatAction;
import org.elasticsearch.rest.action.support.RestResponseListener;
import org.elasticsearch.rest.action.support.RestTable;

public class RestFielddataAction
extends AbstractCatAction {
    @Inject
    public RestFielddataAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_cat/fielddata", this);
        controller.registerHandler(RestRequest.Method.GET, "/_cat/fielddata/{fields}", this);
    }

    @Override
    void doRequest(final RestRequest request, RestChannel channel, Client client) {
        String[] stringArray;
        NodesStatsRequest nodesStatsRequest = new NodesStatsRequest(new String[0]);
        nodesStatsRequest.clear();
        nodesStatsRequest.indices(true);
        String[] fields = request.paramAsStringArray("fields", null);
        CommonStatsFlags commonStatsFlags = nodesStatsRequest.indices();
        if (fields == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "*";
        } else {
            stringArray = fields;
        }
        commonStatsFlags.fieldDataFields(stringArray);
        client.admin().cluster().nodesStats(nodesStatsRequest, (ActionListener<NodesStatsResponse>)new RestResponseListener<NodesStatsResponse>(channel){

            @Override
            public RestResponse buildResponse(NodesStatsResponse nodeStatses) throws Exception {
                return RestTable.buildResponse(RestFielddataAction.this.buildTable(request, nodeStatses), this.channel);
            }
        });
    }

    @Override
    void documentation(StringBuilder sb) {
        sb.append("/_cat/fielddata\n");
        sb.append("/_cat/fielddata/{fields}\n");
    }

    @Override
    Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders().addCell("id", "desc:node id").addCell("host", "alias:h;desc:host name").addCell("ip", "desc:ip address").addCell("node", "alias:n;desc:node name").addCell("total", "text-align:right;desc:total field data usage").endHeaders();
        return table;
    }

    /*
     * WARNING - void declaration
     */
    private Table buildTable(RestRequest request, NodesStatsResponse nodeStatses) {
        ObjectLongMap<String> fields;
        NodeStats ns;
        void var7_9;
        HashSet<String> fieldNames = new HashSet<String>();
        HashMap<NodeStats, ObjectLongOpenHashMap<String>> nodesFields = new HashMap<NodeStats, ObjectLongOpenHashMap<String>>();
        NodeStats[] arr$ = (NodeStats[])nodeStatses.getNodes();
        int len$ = arr$.length;
        boolean bl = false;
        while (var7_9 < len$) {
            ns = arr$[var7_9];
            fields = ns.getIndices().getFieldData().getFields();
            nodesFields.put(ns, (ObjectLongOpenHashMap<String>)fields);
            if (fields != null) {
                for (String key : (String[])((ObjectLongOpenHashMap)fields).keys().toArray(String.class)) {
                    fieldNames.add(key);
                }
            }
            ++var7_9;
        }
        Table table = new Table();
        table.startHeaders().addCell("id", "desc:node id").addCell("host", "alias:h;desc:host name").addCell("ip", "desc:ip address").addCell("node", "alias:n;desc:node name").addCell("total", "text-align:right;desc:total field data usage");
        for (String string : fieldNames) {
            table.addCell(string, "text-align:right;desc:" + string + " field");
        }
        table.endHeaders();
        for (Map.Entry entry : nodesFields.entrySet()) {
            table.startRow();
            ns = (NodeStats)entry.getKey();
            table.addCell(ns.getNode().id());
            table.addCell(ns.getNode().getHostName());
            table.addCell(ns.getNode().getHostAddress());
            table.addCell(ns.getNode().getName());
            table.addCell(ns.getIndices().getFieldData().getMemorySize());
            fields = (ObjectLongMap)entry.getValue();
            for (String fieldName : fieldNames) {
                table.addCell(new ByteSizeValue(fields == null ? 0L : fields.getOrDefault(fieldName, 0L)));
            }
            table.endRow();
        }
        return table;
    }
}

