/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.base.Function;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;

public class InternalAggregations
implements Aggregations,
ToXContent,
Streamable {
    public static final InternalAggregations EMPTY = new InternalAggregations();
    private static final Function<InternalAggregation, Aggregation> SUPERTYPE_CAST = new Function<InternalAggregation, Aggregation>(){

        @Override
        public Aggregation apply(InternalAggregation input) {
            return input;
        }
    };
    private List<InternalAggregation> aggregations = ImmutableList.of();
    private Map<String, InternalAggregation> aggregationsAsMap;

    private InternalAggregations() {
    }

    public InternalAggregations(List<InternalAggregation> aggregations) {
        this.aggregations = aggregations;
    }

    @Override
    public Iterator<Aggregation> iterator() {
        return Iterators.transform(this.aggregations.iterator(), SUPERTYPE_CAST);
    }

    @Override
    public List<Aggregation> asList() {
        return Lists.transform(this.aggregations, SUPERTYPE_CAST);
    }

    @Override
    public Map<String, Aggregation> asMap() {
        return this.getAsMap();
    }

    @Override
    public Map<String, Aggregation> getAsMap() {
        if (this.aggregationsAsMap == null) {
            HashMap<String, InternalAggregation> aggregationsAsMap = Maps.newHashMap();
            for (InternalAggregation aggregation : this.aggregations) {
                aggregationsAsMap.put(aggregation.getName(), aggregation);
            }
            this.aggregationsAsMap = aggregationsAsMap;
        }
        return Maps.transformValues(this.aggregationsAsMap, SUPERTYPE_CAST);
    }

    @Override
    public <A extends Aggregation> A get(String name) {
        return (A)this.asMap().get(name);
    }

    public static InternalAggregations reduce(List<InternalAggregations> aggregationsList, BigArrays bigArrays) {
        if (aggregationsList.isEmpty()) {
            return null;
        }
        HashMap<String, ArrayList<InternalAggregation>> aggByName = new HashMap<String, ArrayList<InternalAggregation>>();
        for (InternalAggregations aggregations : aggregationsList) {
            for (InternalAggregation aggregation : aggregations.aggregations) {
                ArrayList<InternalAggregation> aggs = (ArrayList<InternalAggregation>)aggByName.get(aggregation.getName());
                if (aggs == null) {
                    aggs = new ArrayList<InternalAggregation>(aggregationsList.size());
                    aggByName.put(aggregation.getName(), aggs);
                }
                aggs.add(aggregation);
            }
        }
        ArrayList<InternalAggregation> reducedAggregations = new ArrayList<InternalAggregation>();
        for (Map.Entry entry : aggByName.entrySet()) {
            List aggregations = (List)entry.getValue();
            InternalAggregation first = (InternalAggregation)aggregations.get(0);
            reducedAggregations.add(first.reduce(new InternalAggregation.ReduceContext(aggregations, bigArrays)));
        }
        return new InternalAggregations(reducedAggregations);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.aggregations.isEmpty()) {
            return builder;
        }
        builder.startObject(Fields.AGGREGATIONS);
        this.toXContentInternal(builder, params);
        return builder.endObject();
    }

    public XContentBuilder toXContentInternal(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (Aggregation aggregation : this.aggregations) {
            ((InternalAggregation)aggregation).toXContent(builder, params);
        }
        return builder;
    }

    public static InternalAggregations readAggregations(StreamInput in) throws IOException {
        InternalAggregations result = new InternalAggregations();
        result.readFrom(in);
        return result;
    }

    public static InternalAggregations readOptionalAggregations(StreamInput in) throws IOException {
        return in.readOptionalStreamable(new InternalAggregations());
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int size = in.readVInt();
        if (size == 0) {
            this.aggregations = ImmutableList.of();
            this.aggregationsAsMap = ImmutableMap.of();
        } else {
            this.aggregations = Lists.newArrayListWithCapacity(size);
            for (int i = 0; i < size; ++i) {
                BytesReference type = in.readBytesReference();
                InternalAggregation aggregation = AggregationStreams.stream(type).readResult(in);
                this.aggregations.add(aggregation);
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.aggregations.size());
        for (Aggregation aggregation : this.aggregations) {
            InternalAggregation internal = (InternalAggregation)aggregation;
            out.writeBytesReference(internal.type().stream());
            internal.writeTo(out);
        }
    }

    static class Fields {
        public static final XContentBuilderString AGGREGATIONS = new XContentBuilderString("aggregations");

        Fields() {
        }
    }
}

