/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.base.Predicate;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.collect.Iterators2;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.terms.AbstractStringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.support.BucketPriorityQueue;
import org.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;

public class StringTermsAggregator
extends AbstractStringTermsAggregator {
    private final ValuesSource valuesSource;
    protected final BytesRefHash bucketOrds;
    private final IncludeExclude includeExclude;
    private BytesValues values;

    public StringTermsAggregator(String name, AggregatorFactories factories, ValuesSource valuesSource, long estimatedBucketCount, InternalOrder order, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, AggregationContext aggregationContext, Aggregator parent, Aggregator.SubAggCollectionMode collectionMode) {
        super(name, factories, estimatedBucketCount, aggregationContext, parent, order, bucketCountThresholds, collectionMode);
        this.valuesSource = valuesSource;
        this.includeExclude = includeExclude;
        this.bucketOrds = new BytesRefHash(estimatedBucketCount, aggregationContext.bigArrays());
    }

    @Override
    public boolean shouldCollect() {
        return true;
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        this.values = this.valuesSource.bytesValues();
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        assert (owningBucketOrdinal == 0L);
        int valuesCount = this.values.setDocument(doc);
        for (int i = 0; i < valuesCount; ++i) {
            BytesRef bytes = this.values.nextValue();
            if (this.includeExclude != null && !this.includeExclude.accept(bytes)) continue;
            long bucketOrdinal = this.bucketOrds.add(bytes);
            if (bucketOrdinal < 0L) {
                bucketOrdinal = -1L - bucketOrdinal;
                this.collectExistingBucket(doc, bucketOrdinal);
                continue;
            }
            this.collectBucket(doc, bucketOrdinal);
        }
    }

    private static Iterator<BytesRef> terms(final BytesValues.WithOrdinals bytesValues, boolean reverse) {
        if (reverse) {
            return new UnmodifiableIterator<BytesRef>(){
                long i;
                {
                    this.i = bytesValues.getMaxOrd() - 1L;
                }

                @Override
                public boolean hasNext() {
                    return this.i >= 0L;
                }

                @Override
                public BytesRef next() {
                    return BytesRef.deepCopyOf((BytesRef)bytesValues.getValueByOrd(this.i--));
                }
            };
        }
        return new UnmodifiableIterator<BytesRef>(){
            long i = 0L;

            @Override
            public boolean hasNext() {
                return this.i < bytesValues.getMaxOrd();
            }

            @Override
            public BytesRef next() {
                return BytesRef.deepCopyOf((BytesRef)bytesValues.getValueByOrd(this.i++));
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        int i;
        assert (owningBucketOrdinal == 0L);
        if (this.bucketCountThresholds.getMinDocCount() == 0L && (this.order != InternalOrder.COUNT_DESC || this.bucketOrds.size() < (long)this.bucketCountThresholds.getRequiredSize())) {
            ArrayList<BytesValues.WithOrdinals> valuesWithOrdinals = Lists.newArrayList();
            for (AtomicReaderContext ctx : this.context.searchContext().searcher().getTopReaderContext().leaves()) {
                this.context.setNextReader(ctx);
                BytesValues values = this.valuesSource.bytesValues();
                if (values instanceof BytesValues.WithOrdinals) {
                    valuesWithOrdinals.add((BytesValues.WithOrdinals)values);
                    continue;
                }
                for (int docId = 0; docId < ctx.reader().maxDoc(); ++docId) {
                    int valueCount = values.setDocument(docId);
                    for (int i2 = 0; i2 < valueCount; ++i2) {
                        BytesRef term = values.nextValue();
                        if (this.includeExclude != null && !this.includeExclude.accept(term)) continue;
                        this.bucketOrds.add(term);
                    }
                }
            }
            if (valuesWithOrdinals.size() > 0) {
                boolean reverse = this.order == InternalOrder.TERM_DESC;
                Comparator comparator = BytesRef.getUTF8SortedAsUnicodeComparator();
                if (reverse) {
                    comparator = Collections.reverseOrder(comparator);
                }
                Iterator[] iterators = new Iterator[valuesWithOrdinals.size()];
                for (int i3 = 0; i3 < valuesWithOrdinals.size(); ++i3) {
                    iterators[i3] = StringTermsAggregator.terms((BytesValues.WithOrdinals)valuesWithOrdinals.get(i3), reverse);
                }
                Iterator terms = Iterators2.mergeSorted(Arrays.asList(iterators), comparator, true);
                if (this.includeExclude != null) {
                    terms = Iterators.filter(terms, new Predicate<BytesRef>(){

                        @Override
                        public boolean apply(BytesRef input) {
                            return StringTermsAggregator.this.includeExclude.accept(input);
                        }
                    });
                }
                if (this.order == InternalOrder.COUNT_ASC) {
                    int added = 0;
                    while (added < this.bucketCountThresholds.getShardSize() && terms.hasNext()) {
                        if (this.bucketOrds.add((BytesRef)terms.next()) < 0L) continue;
                        ++added;
                    }
                } else if (this.order == InternalOrder.COUNT_DESC) {
                    while (this.bucketOrds.size() < (long)this.bucketCountThresholds.getRequiredSize() && terms.hasNext()) {
                        this.bucketOrds.add((BytesRef)terms.next());
                    }
                } else if (this.order == InternalOrder.TERM_ASC || this.order == InternalOrder.TERM_DESC) {
                    for (i = 0; i < this.bucketCountThresholds.getRequiredSize() && terms.hasNext(); ++i) {
                        this.bucketOrds.add((BytesRef)terms.next());
                    }
                } else {
                    while (terms.hasNext()) {
                        this.bucketOrds.add((BytesRef)terms.next());
                    }
                }
            }
        }
        int size = (int)Math.min(this.bucketOrds.size(), (long)this.bucketCountThresholds.getShardSize());
        BucketPriorityQueue ordered = new BucketPriorityQueue(size, this.order.comparator(this));
        StringTerms.Bucket spare = null;
        int i4 = 0;
        while ((long)i4 < this.bucketOrds.size()) {
            if (spare == null) {
                spare = new StringTerms.Bucket(new BytesRef(), 0L, null);
            }
            this.bucketOrds.get(i4, spare.termBytes);
            spare.docCount = this.bucketDocCount(i4);
            spare.bucketOrd = i4;
            if (this.bucketCountThresholds.getShardMinDocCount() <= spare.docCount) {
                spare = (StringTerms.Bucket)ordered.insertWithOverflow(spare);
            }
            ++i4;
        }
        InternalTerms.Bucket[] list = new InternalTerms.Bucket[ordered.size()];
        long[] survivingBucketOrds = new long[ordered.size()];
        for (i = ordered.size() - 1; i >= 0; --i) {
            StringTerms.Bucket bucket = (StringTerms.Bucket)ordered.pop();
            survivingBucketOrds[i] = bucket.bucketOrd;
            list[i] = bucket;
        }
        this.runDeferredCollections(survivingBucketOrds);
        for (i = 0; i < list.length; ++i) {
            StringTerms.Bucket bucket = (StringTerms.Bucket)list[i];
            bucket.termBytes = BytesRef.deepCopyOf((BytesRef)bucket.termBytes);
            bucket.aggregations = this.bucketAggregations(bucket.bucketOrd);
        }
        return new StringTerms(this.name, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), Arrays.asList(list));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new StringTerms(this.name, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), Collections.emptyList());
    }

    @Override
    public void doClose() {
        Releasables.close(this.bucketOrds);
    }
}

