/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.AbstractTermsParametersParser;
import org.elasticsearch.search.aggregations.bucket.terms.InternalOrder;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.OrderPath;

public abstract class TermsAggregator
extends BucketsAggregator {
    protected final BucketCountThresholds bucketCountThresholds;
    protected InternalOrder order;
    protected Aggregator aggUsedForSorting;
    protected Aggregator.SubAggCollectionMode subAggCollectMode;

    public TermsAggregator(String name, Aggregator.BucketAggregationMode bucketAggregationMode, AggregatorFactories factories, long estimatedBucketsCount, AggregationContext context, Aggregator parent, BucketCountThresholds bucketCountThresholds, InternalOrder order, Aggregator.SubAggCollectionMode subAggCollectMode) {
        super(name, bucketAggregationMode, factories, estimatedBucketsCount, context, parent);
        this.bucketCountThresholds = bucketCountThresholds;
        this.order = InternalOrder.validate(order, this);
        this.subAggCollectMode = subAggCollectMode;
        if (order instanceof InternalOrder.Aggregation) {
            OrderPath path = ((InternalOrder.Aggregation)order).path();
            this.aggUsedForSorting = path.resolveTopmostAggregator(this, false);
        }
    }

    @Override
    protected boolean shouldDefer(Aggregator aggregator) {
        return this.subAggCollectMode == Aggregator.SubAggCollectionMode.BREADTH_FIRST && aggregator != this.aggUsedForSorting;
    }

    public static class BucketCountThresholds {
        private Explicit<Long> minDocCount;
        private Explicit<Long> shardMinDocCount;
        private Explicit<Integer> requiredSize;
        private Explicit<Integer> shardSize;

        public BucketCountThresholds(long minDocCount, long shardMinDocCount, int requiredSize, int shardSize) {
            this.minDocCount = new Explicit<Long>(minDocCount, false);
            this.shardMinDocCount = new Explicit<Long>(shardMinDocCount, false);
            this.requiredSize = new Explicit<Integer>(requiredSize, false);
            this.shardSize = new Explicit<Integer>(shardSize, false);
        }

        public BucketCountThresholds() {
            this(-1L, -1L, -1, -1);
        }

        public BucketCountThresholds(BucketCountThresholds bucketCountThresholds) {
            this(bucketCountThresholds.minDocCount.value(), bucketCountThresholds.shardMinDocCount.value(), bucketCountThresholds.requiredSize.value(), bucketCountThresholds.shardSize.value());
        }

        public void ensureValidity() {
            if (this.shardSize.value() == 0) {
                this.setShardSize(Integer.MAX_VALUE);
            }
            if (this.requiredSize.value() == 0) {
                this.setRequiredSize(Integer.MAX_VALUE);
            }
            if (this.shardSize.value() < this.requiredSize.value()) {
                this.setShardSize(this.requiredSize.value());
            }
            if (this.shardMinDocCount.value() > this.minDocCount.value()) {
                this.setShardMinDocCount(this.minDocCount.value());
            }
            if (this.requiredSize.value() < 0 || this.minDocCount.value() < 0L) {
                throw new ElasticsearchException("parameters [requiredSize] and [minDocCount] must be >=0 in terms aggregation.");
            }
        }

        public long getShardMinDocCount() {
            return this.shardMinDocCount.value();
        }

        public void setShardMinDocCount(long shardMinDocCount) {
            this.shardMinDocCount = new Explicit<Long>(shardMinDocCount, true);
        }

        public long getMinDocCount() {
            return this.minDocCount.value();
        }

        public void setMinDocCount(long minDocCount) {
            this.minDocCount = new Explicit<Long>(minDocCount, true);
        }

        public int getRequiredSize() {
            return this.requiredSize.value();
        }

        public void setRequiredSize(int requiredSize) {
            this.requiredSize = new Explicit<Integer>(requiredSize, true);
        }

        public int getShardSize() {
            return this.shardSize.value();
        }

        public void setShardSize(int shardSize) {
            this.shardSize = new Explicit<Integer>(shardSize, true);
        }

        public void toXContent(XContentBuilder builder) throws IOException {
            if (this.requiredSize.explicit()) {
                builder.field(AbstractTermsParametersParser.REQUIRED_SIZE_FIELD_NAME.getPreferredName(), this.requiredSize.value());
            }
            if (this.shardSize.explicit()) {
                builder.field(AbstractTermsParametersParser.SHARD_SIZE_FIELD_NAME.getPreferredName(), this.shardSize.value());
            }
            if (this.minDocCount.explicit()) {
                builder.field(AbstractTermsParametersParser.MIN_DOC_COUNT_FIELD_NAME.getPreferredName(), this.minDocCount.value());
            }
            if (this.shardMinDocCount.explicit()) {
                builder.field(AbstractTermsParametersParser.SHARD_MIN_DOC_COUNT_FIELD_NAME.getPreferredName(), this.shardMinDocCount.value());
            }
        }
    }
}

