/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.geobounds;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.geobounds.InternalGeoBounds;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public final class GeoBoundsAggregator
extends MetricsAggregator {
    private final ValuesSource.GeoPoint valuesSource;
    private final boolean wrapLongitude;
    private DoubleArray tops;
    private DoubleArray bottoms;
    private DoubleArray posLefts;
    private DoubleArray posRights;
    private DoubleArray negLefts;
    private DoubleArray negRights;
    private GeoPointValues values;

    protected GeoBoundsAggregator(String name, long estimatedBucketsCount, AggregationContext aggregationContext, Aggregator parent, ValuesSource.GeoPoint valuesSource, boolean wrapLongitude) {
        super(name, estimatedBucketsCount, aggregationContext, parent);
        this.valuesSource = valuesSource;
        this.wrapLongitude = wrapLongitude;
        if (valuesSource != null) {
            long initialSize = estimatedBucketsCount < 2L ? 1L : estimatedBucketsCount;
            this.tops = this.bigArrays.newDoubleArray(initialSize, false);
            this.tops.fill(0L, this.tops.size(), Double.NEGATIVE_INFINITY);
            this.bottoms = this.bigArrays.newDoubleArray(initialSize, false);
            this.bottoms.fill(0L, this.bottoms.size(), Double.POSITIVE_INFINITY);
            this.posLefts = this.bigArrays.newDoubleArray(initialSize, false);
            this.posLefts.fill(0L, this.posLefts.size(), Double.POSITIVE_INFINITY);
            this.posRights = this.bigArrays.newDoubleArray(initialSize, false);
            this.posRights.fill(0L, this.posRights.size(), Double.NEGATIVE_INFINITY);
            this.negLefts = this.bigArrays.newDoubleArray(initialSize, false);
            this.negLefts.fill(0L, this.negLefts.size(), Double.POSITIVE_INFINITY);
            this.negRights = this.bigArrays.newDoubleArray(initialSize, false);
            this.negRights.fill(0L, this.negRights.size(), Double.NEGATIVE_INFINITY);
        }
    }

    @Override
    public boolean shouldCollect() {
        return this.valuesSource != null;
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        this.values = this.valuesSource.geoPointValues();
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        if (this.valuesSource == null) {
            return this.buildEmptyAggregation();
        }
        double top = this.tops.get(owningBucketOrdinal);
        double bottom = this.bottoms.get(owningBucketOrdinal);
        double posLeft = this.posLefts.get(owningBucketOrdinal);
        double posRight = this.posRights.get(owningBucketOrdinal);
        double negLeft = this.negLefts.get(owningBucketOrdinal);
        double negRight = this.negRights.get(owningBucketOrdinal);
        return new InternalGeoBounds(this.name, top, bottom, posLeft, posRight, negLeft, negRight, this.wrapLongitude);
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalGeoBounds(this.name, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, this.wrapLongitude);
    }

    @Override
    public void collect(int docId, long owningBucketOrdinal) throws IOException {
        if (owningBucketOrdinal >= this.tops.size()) {
            long from = this.tops.size();
            this.tops = this.bigArrays.grow(this.tops, owningBucketOrdinal + 1L);
            this.tops.fill(from, this.tops.size(), Double.NEGATIVE_INFINITY);
            this.bottoms = this.bigArrays.resize(this.bottoms, this.tops.size());
            this.bottoms.fill(from, this.bottoms.size(), Double.NEGATIVE_INFINITY);
            this.posLefts = this.bigArrays.resize(this.posLefts, this.tops.size());
            this.posLefts.fill(from, this.posLefts.size(), Double.NEGATIVE_INFINITY);
            this.posLefts = this.bigArrays.resize(this.posLefts, this.tops.size());
            this.posRights.fill(from, this.posRights.size(), Double.NEGATIVE_INFINITY);
            this.negLefts = this.bigArrays.resize(this.negLefts, this.tops.size());
            this.negLefts.fill(from, this.negLefts.size(), Double.NEGATIVE_INFINITY);
            this.negRights = this.bigArrays.resize(this.negRights, this.tops.size());
            this.negRights.fill(from, this.negRights.size(), Double.NEGATIVE_INFINITY);
        }
        int valuesCount = this.values.setDocument(docId);
        for (int i = 0; i < valuesCount; ++i) {
            GeoPoint value = this.values.nextValue();
            double top = this.tops.get(owningBucketOrdinal);
            if (value.lat() > top) {
                top = value.lat();
            }
            double bottom = this.bottoms.get(owningBucketOrdinal);
            if (value.lat() < bottom) {
                bottom = value.lat();
            }
            double posLeft = this.posLefts.get(owningBucketOrdinal);
            if (value.lon() > 0.0 && value.lon() < posLeft) {
                posLeft = value.lon();
            }
            double posRight = this.posRights.get(owningBucketOrdinal);
            if (value.lon() > 0.0 && value.lon() > posRight) {
                posRight = value.lon();
            }
            double negLeft = this.negLefts.get(owningBucketOrdinal);
            if (value.lon() < 0.0 && value.lon() < negLeft) {
                negLeft = value.lon();
            }
            double negRight = this.negRights.get(owningBucketOrdinal);
            if (value.lon() < 0.0 && value.lon() > negRight) {
                negRight = value.lon();
            }
            this.tops.set(owningBucketOrdinal, top);
            this.bottoms.set(owningBucketOrdinal, bottom);
            this.posLefts.set(owningBucketOrdinal, posLeft);
            this.posRights.set(owningBucketOrdinal, posRight);
            this.negLefts.set(owningBucketOrdinal, negLeft);
            this.negRights.set(owningBucketOrdinal, negRight);
        }
    }

    @Override
    public void doClose() {
        Releasables.close(this.tops, this.bottoms, this.posLefts, this.posRights, this.negLefts, this.negRights);
    }

    public static class Factory
    extends ValuesSourceAggregatorFactory<ValuesSource.GeoPoint> {
        private final boolean wrapLongitude;

        protected Factory(String name, ValuesSourceConfig<ValuesSource.GeoPoint> config, boolean wrapLongitude) {
            super(name, InternalGeoBounds.TYPE.name(), config);
            this.wrapLongitude = wrapLongitude;
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent) {
            return new GeoBoundsAggregator(this.name, 0L, aggregationContext, parent, null, this.wrapLongitude);
        }

        @Override
        protected Aggregator create(ValuesSource.GeoPoint valuesSource, long expectedBucketsCount, AggregationContext aggregationContext, Aggregator parent) {
            return new GeoBoundsAggregator(this.name, expectedBucketsCount, aggregationContext, parent, valuesSource, this.wrapLongitude);
        }
    }
}

