/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.tophits;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.tophits.TopHits;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.InternalSearchHits;

public class InternalTopHits
extends InternalMetricsAggregation
implements TopHits {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("top_hits");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalTopHits readResult(StreamInput in) throws IOException {
            InternalTopHits buckets = new InternalTopHits();
            buckets.readFrom(in);
            return buckets;
        }
    };
    private int from;
    private int size;
    private Sort sort;
    private TopDocs topDocs;
    private InternalSearchHits searchHits;

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    InternalTopHits() {
    }

    public InternalTopHits(String name, int from, int size, Sort sort, TopDocs topDocs, InternalSearchHits searchHits) {
        this.name = name;
        this.from = from;
        this.size = size;
        this.sort = sort;
        this.topDocs = topDocs;
        this.searchHits = searchHits;
    }

    public InternalTopHits(String name, InternalSearchHits searchHits) {
        this.name = name;
        this.searchHits = searchHits;
        this.topDocs = Lucene.EMPTY_TOP_DOCS;
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public SearchHits getHits() {
        return this.searchHits;
    }

    @Override
    public InternalAggregation reduce(InternalAggregation.ReduceContext reduceContext) {
        List<InternalAggregation> aggregations = reduceContext.aggregations();
        TopDocs[] shardDocs = new TopDocs[aggregations.size()];
        InternalSearchHits[] shardHits = new InternalSearchHits[aggregations.size()];
        for (int i = 0; i < shardDocs.length; ++i) {
            InternalTopHits topHitsAgg = (InternalTopHits)aggregations.get(i);
            shardDocs[i] = topHitsAgg.topDocs;
            shardHits[i] = topHitsAgg.searchHits;
        }
        try {
            int[] tracker = new int[shardHits.length];
            TopDocs reducedTopDocs = TopDocs.merge((Sort)this.sort, (int)this.from, (int)this.size, (TopDocs[])shardDocs);
            InternalSearchHit[] hits = new InternalSearchHit[reducedTopDocs.scoreDocs.length];
            for (int i = 0; i < reducedTopDocs.scoreDocs.length; ++i) {
                int position;
                ScoreDoc scoreDoc = reducedTopDocs.scoreDocs[i];
                do {
                    int n = scoreDoc.shardIndex;
                    tracker[n] = tracker[n] + 1;
                } while (shardDocs[scoreDoc.shardIndex].scoreDocs[position] != scoreDoc);
                hits[i] = (InternalSearchHit)shardHits[scoreDoc.shardIndex].getAt(position);
            }
            return new InternalTopHits(this.name, new InternalSearchHits(hits, reducedTopDocs.totalHits, reducedTopDocs.getMaxScore()));
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToElastic(e);
        }
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.from = in.readVInt();
        this.size = in.readVInt();
        this.topDocs = Lucene.readTopDocs(in);
        if (this.topDocs instanceof TopFieldDocs) {
            this.sort = new Sort(((TopFieldDocs)this.topDocs).fields);
        }
        this.searchHits = InternalSearchHits.readSearchHits(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeVInt(this.from);
        out.writeVInt(this.size);
        Lucene.writeTopDocs(out, this.topDocs, 0);
        this.searchHits.writeTo(out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        this.searchHits.toXContent(builder, params);
        builder.endObject();
        return builder;
    }
}

