/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.suggest.SuggestContextParser;
import org.elasticsearch.search.suggest.SuggestUtils;
import org.elasticsearch.search.suggest.Suggesters;
import org.elasticsearch.search.suggest.SuggestionSearchContext;

public final class SuggestParseElement
implements SearchParseElement {
    private Suggesters suggesters;

    @Inject
    public SuggestParseElement(Suggesters suggesters) {
        this.suggesters = suggesters;
    }

    @Override
    public void parse(XContentParser parser, SearchContext context) throws Exception {
        SuggestionSearchContext suggestionSearchContext = this.parseInternal(parser, context.mapperService(), context.shardTarget().index(), context.shardTarget().shardId());
        context.suggest(suggestionSearchContext);
    }

    public SuggestionSearchContext parseInternal(XContentParser parser, MapperService mapperService, String index, int shardId) throws IOException {
        XContentParser.Token token;
        SuggestionSearchContext suggestionSearchContext = new SuggestionSearchContext();
        BytesRef globalText = null;
        String fieldName = null;
        HashMap<String, SuggestionSearchContext.SuggestionContext> suggestionContexts = Maps.newHashMap();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if ("text".equals(fieldName)) {
                    globalText = parser.bytes();
                    continue;
                }
                throw new ElasticsearchIllegalArgumentException("[suggest] does not support [" + fieldName + "]");
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            String suggestionName = fieldName;
            BytesRef suggestText = null;
            SuggestionSearchContext.SuggestionContext suggestionContext = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    fieldName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if ("text".equals(fieldName)) {
                        suggestText = parser.bytes();
                        continue;
                    }
                    throw new ElasticsearchIllegalArgumentException("[suggest] does not support [" + fieldName + "]");
                }
                if (token != XContentParser.Token.START_OBJECT) continue;
                if (suggestionName == null) {
                    throw new ElasticsearchIllegalArgumentException("Suggestion must have name");
                }
                if (this.suggesters.get(fieldName) == null) {
                    throw new ElasticsearchIllegalArgumentException("Suggester[" + fieldName + "] not supported");
                }
                SuggestContextParser contextParser = this.suggesters.get(fieldName).getContextParser();
                suggestionContext = contextParser.parse(parser, mapperService);
            }
            if (suggestionContext == null) continue;
            suggestionContext.setText(suggestText);
            suggestionContexts.put(suggestionName, suggestionContext);
        }
        for (Map.Entry entry : suggestionContexts.entrySet()) {
            String suggestionName = (String)entry.getKey();
            SuggestionSearchContext.SuggestionContext suggestionContext = (SuggestionSearchContext.SuggestionContext)entry.getValue();
            suggestionContext.setShard(shardId);
            suggestionContext.setIndex(index);
            SuggestUtils.verifySuggestion(mapperService, globalText, suggestionContext);
            suggestionSearchContext.addSuggestion(suggestionName, suggestionContext);
        }
        return suggestionSearchContext;
    }
}

