/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.udm;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import java.util.Collections;
import java.util.Set;

@PublicApiRef
@Metadata(description="A package of a certain version of an application. Groups all deployable artifact CIs for an application for a certain version. Is contained by the Application CI.")
public class DeploymentPackage
extends Version {
    @Property(description="The set of deployables that are part of this package", asContainment=true)
    private Set<Deployable> deployables = Sets.newHashSet();

    public DeploymentPackage() {
    }

    public DeploymentPackage(Deployable ... deployables) {
        this.deployables = Sets.newHashSet((Object[])deployables);
    }

    @Override
    public Set<Deployable> getDeployables() {
        return Collections.unmodifiableSet(this.deployables);
    }

    public void setDeployables(Set<Deployable> deployables) {
        this.deployables = deployables;
    }

    public void addDeployable(Deployable artifact) {
        this.deployables.add((Deployable)Preconditions.checkNotNull((Object)artifact));
    }
}

