/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.validation;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;

@Retention(value=RetentionPolicy.RUNTIME)
@Rule(clazz=Validator.class, type="no-self-reference")
@Target(value={ElementType.TYPE})
public @interface NoSelfReference {
    public String referenceField();

    public static class Validator
    implements com.xebialabs.deployit.plugin.api.validation.Validator<ConfigurationItem> {
        private String referenceField;

        @Override
        public void validate(ConfigurationItem value, ValidationContext context) {
            final String id = value.getId();
            Collection property = (Collection)value.getProperty(this.referenceField);
            ArrayList filter = Lists.newArrayList((Iterable)Iterables.filter((Iterable)property, (Predicate)new Predicate<ConfigurationItem>(){

                public boolean apply(ConfigurationItem input) {
                    return input.getId().equals(id);
                }
            }));
            if (!filter.isEmpty()) {
                context.error("%s [%s] cannot contain a reference to itself.", value.getType(), id);
            }
        }
    }
}

