/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key;

import de.schlichtherle.truezip.crypto.SuspensionPenalty;
import de.schlichtherle.truezip.key.KeyProvider;
import de.schlichtherle.truezip.key.SafeKey;
import de.schlichtherle.truezip.key.UnknownKeyException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
public abstract class SafeKeyProvider<K extends SafeKey<K>>
implements KeyProvider<K> {
    public static final int MIN_KEY_RETRY_DELAY = 3000;
    @CheckForNull
    private volatile K key;
    private final ThreadLocal<Long> invalidated = new ThreadLocalLong();

    protected SafeKeyProvider() {
    }

    @Override
    public final K getWriteKey() throws UnknownKeyException {
        this.retrieveWriteKey();
        return this.getNonNullKey();
    }

    protected abstract void retrieveWriteKey() throws UnknownKeyException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final K getReadKey(boolean invalid) throws UnknownKeyException {
        if (invalid) {
            this.invalidated.set(System.currentTimeMillis());
        }
        try {
            this.retrieveReadKey(invalid);
        }
        finally {
            this.enforceSuspensionPenalty();
        }
        return this.getNonNullKey();
    }

    protected abstract void retrieveReadKey(boolean var1) throws UnknownKeyException;

    private K getNonNullKey() throws UnknownKeyException {
        K key = this.getKey();
        if (null == key) {
            throw new UnknownKeyException();
        }
        return key;
    }

    @CheckForNull
    protected K getKey() {
        K key = this.key;
        return (K)(null == key ? null : (SafeKey)key.clone());
    }

    @Override
    public void setKey(@CheckForNull K newKey) {
        K oldKey = this.key;
        SafeKey safeKey = this.key = null == newKey ? null : (SafeKey)newKey.clone();
        if (null != oldKey) {
            oldKey.reset();
        }
    }

    private void enforceSuspensionPenalty() {
        SuspensionPenalty.enforce(this.invalidated.get());
    }

    private static final class ThreadLocalLong
    extends ThreadLocal<Long> {
        private ThreadLocalLong() {
        }

        @Override
        public Long initialValue() {
            return 0L;
        }
    }
}

