/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.util;

import de.schlichtherle.truezip.util.QuotedUriSyntaxException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import net.jcip.annotations.NotThreadSafe;

@DefaultAnnotation(value={NonNull.class})
@NotThreadSafe
public final class UriEncoder {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String ALPHANUM_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String MARK_CHARS = "-_.!~*'()";
    private static final String DEFAULT_LEGAL_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-_.!~*'(),;$&+=@";
    private final CharsetEncoder encoder;
    private final boolean encode;
    private final boolean raw;
    @CheckForNull
    private StringBuilder stringBuilder;

    public UriEncoder() {
        this(UTF8, false);
    }

    public UriEncoder(boolean raw) {
        this(UTF8, raw);
    }

    public UriEncoder(@CheckForNull Charset charset) {
        this(charset, false);
    }

    public UriEncoder(@CheckForNull Charset charset, boolean raw) {
        this.encode = null != charset;
        if (!this.encode) {
            charset = UTF8;
        }
        this.encoder = charset.newEncoder();
        this.raw = raw;
    }

    boolean isRaw() {
        return this.raw;
    }

    private static void quote(char dc, StringBuilder eS) {
        UriEncoder.quote(UTF8.encode(CharBuffer.wrap(Character.toString(dc))), eS);
    }

    private static void quote(ByteBuffer eB, StringBuilder eS) {
        while (eB.hasRemaining()) {
            byte eb = eB.get();
            eS.append('%');
            eS.append(HEX[eb >> 4 & 0xF]);
            eS.append(HEX[eb & 0xF]);
        }
    }

    public String encode(String dS, Encoding comp) {
        try {
            StringBuilder eS = this.encode(dS, comp, null);
            return null != eS ? eS.toString() : dS;
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @CheckForNull
    public StringBuilder encode(String dS, Encoding comp, @CheckForNull StringBuilder eS) throws URISyntaxException {
        String[] escapes = comp.escapes;
        CharBuffer dC = CharBuffer.wrap(dS);
        ByteBuffer eB = null;
        CharsetEncoder enc = this.encoder;
        boolean encode = this.encode;
        while (dC.hasRemaining()) {
            dC.mark();
            char dc = dC.get();
            if (dc < '\u0080') {
                String es = escapes[dc];
                if (!(null == es || '%' == dc && this.raw)) {
                    if (null == eB) {
                        if (null == eS) {
                            eS = this.stringBuilder;
                            if (null == eS) {
                                eS = this.stringBuilder = new StringBuilder();
                            } else {
                                eS.setLength(0);
                            }
                            eS.append(dS, 0, dC.position() - 1);
                        }
                        eB = ByteBuffer.allocate(3);
                    }
                    eS.append(es);
                    continue;
                }
                if (null == eS) continue;
                eS.append(dc);
                continue;
            }
            if (Character.isISOControl(dc) || Character.isSpaceChar(dc) || encode) {
                if (null == eB) {
                    if (null == eS) {
                        eS = this.stringBuilder;
                        if (null == eS) {
                            eS = this.stringBuilder = new StringBuilder();
                        } else {
                            eS.setLength(0);
                        }
                        eS.append(dS, 0, dC.position() - 1);
                    }
                    eB = ByteBuffer.allocate(3);
                }
                int p = dC.position();
                dC.reset();
                dC.limit(p);
                CoderResult cr = enc.reset().encode(dC, eB, true);
                if (CoderResult.UNDERFLOW != cr || CoderResult.UNDERFLOW != (cr = enc.flush(eB))) {
                    assert (CoderResult.OVERFLOW != cr);
                    throw new QuotedUriSyntaxException((Object)dS, cr.toString());
                }
                eB.flip();
                UriEncoder.quote(eB, eS);
                eB.clear();
                dC.limit(dC.capacity());
                continue;
            }
            if (null == eS) continue;
            eS.append(dc);
        }
        return null == eB ? null : eS;
    }

    public static enum Encoding {
        ANY("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-_.!~*'(),;$&+=@"),
        AUTHORITY("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-_.!~*'(),;$&+=@:[]"),
        PATH("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-_.!~*'(),;$&+=@/"),
        ABSOLUTE_PATH("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-_.!~*'(),;$&+=@:/"),
        QUERY("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-_.!~*'(),;$&+=@:/?"),
        FRAGMENT("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-_.!~*'(),;$&+=@:/?");

        private final String[] escapes = new String[128];

        private Encoding(String legal) {
            StringBuilder sb = new StringBuilder();
            for (char c = '\u0000'; c < '\u0080'; c = (char)((char)(c + 1))) {
                if (legal.indexOf(c) >= 0) continue;
                sb.setLength(0);
                UriEncoder.quote(c, sb);
                this.escapes[c] = sb.toString();
            }
        }
    }
}

