/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.xltest.domain.ScriptedConfigurationItem;
import com.xebialabs.xltest.repository.ScriptExecutionException;
import com.xebialabs.xltest.repository.ScriptExecutor;
import com.xebialabs.xltest.repository.ScriptExecutorHolder;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import javax.jcr.RepositoryException;
import javax.script.SimpleScriptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DemoData {
    private Logger LOG = LoggerFactory.getLogger(DemoData.class);

    public void provision(Object elasticSearchBooter, RepositoryService repositoryService) {
        try {
            this.setUpInitialData(repositoryService, elasticSearchBooter);
        }
        catch (RepositoryException e) {
            this.LOG.warn("Unable to fully provision XL Test", (Throwable)e);
        }
    }

    private void setUpInitialData(RepositoryService repositoryService, Object elasticSearchBooter) throws RepositoryException {
        if (this.demoDataHasBeenLoadedAlready(repositoryService)) {
            return;
        }
        try {
            this.initDirectoriesInRepository(repositoryService);
            this.initDemoData(repositoryService, elasticSearchBooter);
        }
        catch (ScriptExecutionException e) {
            throw new RepositoryException("Could not set up a basic configuration", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new RepositoryException("Could not set up a basic configuration", (Throwable)e);
        }
    }

    private boolean demoDataHasBeenLoadedAlready(RepositoryService jcrRepositoryService) {
        return jcrRepositoryService.exists("Configuration/TestSpecifications");
    }

    private Directory directory(String path) {
        Directory dir = new Directory();
        dir.setId(path);
        return dir;
    }

    private void initDirectoriesInRepository(RepositoryService repositoryService) {
        repositoryService.createOrUpdate((ConfigurationItem[])new Directory[]{this.directory("Configuration/Reports"), this.directory("Configuration/Hosts"), this.directory("Configuration/TestSpecifications"), this.directory("Configuration/Dashboards"), this.directory("Configuration/TestExecutors")});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDemoData(RepositoryService repositoryService, Object elasticSearchBooter) throws ScriptExecutionException, FileNotFoundException {
        ScriptExecutor executor = ScriptExecutorHolder.getScriptExecutor();
        SimpleScriptContext scriptContext = new SimpleScriptContext();
        PrintWriter executionLog = new PrintWriter(new ScriptedConfigurationItem.LogWriter("DemoData"));
        scriptContext.setWriter(executionLog);
        scriptContext.setErrorWriter(executionLog);
        try {
            scriptContext.setAttribute("repository", repositoryService, 100);
            scriptContext.setAttribute("logger", LoggerFactory.getLogger((String)"Script"), 100);
            scriptContext.setAttribute("client", elasticSearchBooter, 100);
            executor.evalScriptFile("demodata/generate.py", scriptContext);
        }
        finally {
            executionLog.close();
        }
    }
}

