/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.resources;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.xltest.domain.Report;
import com.xebialabs.xltest.domain.TestSpecification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/data")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class DataController {
    private static final Logger LOG = LoggerFactory.getLogger((String)DataController.class.getName());
    private RepositoryService repository;

    @Autowired
    public DataController(RepositoryService repository) {
        this.repository = repository;
    }

    @GET
    @Path(value="/")
    public Collection<BaseConfigurationItem> getAll(@QueryParam(value="type") String type) {
        SearchParameters query = new SearchParameters();
        if (type != null) {
            query.setType(Type.valueOf((String)type));
        }
        return this.repository.listEntities(query);
    }

    @GET
    @Path(value="/{id:.+}")
    public BaseConfigurationItem get(@PathParam(value="id") String id) {
        LOG.info("reading item with id: " + id);
        return (BaseConfigurationItem)this.repository.read(id);
    }

    @PUT
    @Path(value="/{id:.+}")
    public Response update(@PathParam(value="id") String id, BaseConfigurationItem item) {
        LOG.info("update item with id: " + item.getId());
        if (id.equals(item.getId())) {
            for (PropertyDescriptor propertyDescriptor : item.getType().getDescriptor().getPropertyDescriptors()) {
                String name = propertyDescriptor.getName();
                Object propertyValue = propertyDescriptor.get((ConfigurationItem)item);
                LOG.info("set property " + name + " to value: " + propertyValue);
            }
            this.repository.createOrUpdate((ConfigurationItem[])new BaseConfigurationItem[]{item});
            return Response.status((int)201).entity((Object)item).build();
        }
        return Response.status((int)409).entity((Object)item).build();
    }

    @POST
    @Path(value="/")
    public Response create(BaseConfigurationItem item) {
        this.addPrefixIfNeeded(item);
        LOG.info("create item with id: " + item.getId());
        ArrayList<ConfigurationItem> toBeCreatedItems = new ArrayList<ConfigurationItem>();
        toBeCreatedItems.add((ConfigurationItem)item);
        this.searchForNestedToBeCreatedCis((ConfigurationItem)item, toBeCreatedItems);
        try {
            this.repository.create(toBeCreatedItems.toArray(new ConfigurationItem[toBeCreatedItems.size()]));
            return Response.status((int)201).entity((Object)item).build();
        }
        catch (ItemAlreadyExistsException e) {
            return Response.status((int)409).entity((Object)item).build();
        }
    }

    private void searchForNestedToBeCreatedCis(ConfigurationItem item, List<ConfigurationItem> toBeCreatedCis) {
        for (PropertyDescriptor property : item.getType().getDescriptor().getPropertyDescriptors()) {
            ConfigurationItem child;
            if (property.getKind() != PropertyKind.CI || (child = (ConfigurationItem)item.getProperty(property.getName())) == null || this.repository.exists(child.getId())) continue;
            toBeCreatedCis.add(0, child);
            this.searchForNestedToBeCreatedCis(child, toBeCreatedCis);
        }
    }

    @DELETE
    @Path(value="/{id:.+}")
    @Consumes(value={"*/*"})
    public Response delete(@PathParam(value="id") String id) {
        LOG.info("delete item with id: " + id);
        this.repository.delete(new String[]{id});
        return Response.ok().build();
    }

    public void addPrefixIfNeeded(BaseConfigurationItem item) {
        String id = item.getId();
        if (id.startsWith("Configuration") || id.startsWith("Applications") || id.startsWith("Infrastructure")) {
            return;
        }
        String rootNodeName = item.getType().getDescriptor().getRoot().getRootNodeName();
        if (rootNodeName == null) {
            throw new RuntimeException("Type " + item.getType() + " is unrooted!");
        }
        String subdir = "";
        if (item.getType().instanceOf(Type.valueOf(Report.class))) {
            subdir = "Reports";
        }
        if (item.getType().instanceOf(Type.valueOf(TestSpecification.class))) {
            subdir = "TestSpecifications";
        }
        if (!"".equals(subdir)) {
            subdir = subdir + "/";
        }
        item.setId(rootNodeName + "/" + subdir + id);
    }
}

