/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.resources;

import com.xebialabs.xltest.domain.TestRun;
import com.xebialabs.xltest.repository.TestRunsRepository;
import com.xebialabs.xltest.resources.ExecuteController;
import com.xebialabs.xltest.view.ExecutionParameters;
import java.io.IOException;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/rerun")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class RerunController {
    private final TestRunsRepository testRunsRepository;
    private final ExecuteController executeController;

    @Autowired
    public RerunController(TestRunsRepository testRunsRepository, ExecuteController executeController) {
        this.testRunsRepository = testRunsRepository;
        this.executeController = executeController;
    }

    @GET
    @Path(value="/{runId}/{suite}")
    public Response rerun(@PathParam(value="runId") String runId, @PathParam(value="suite") String suite) throws IOException, InterruptedException {
        TestRun testRun = this.testRunsRepository.getTestRun(runId);
        String testSpecificationName = testRun.getTestSpecificationName();
        ExecutionParameters executionParameters = new ExecutionParameters(testRun.getParameters());
        Map<String, Object> parameters = executionParameters.getParameters();
        parameters.put("suiteName", suite);
        return this.executeController.execute(testSpecificationName, executionParameters);
    }
}

