/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.resources;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.domain.Dashboard;
import com.xebialabs.xltest.domain.Executable;
import com.xebialabs.xltest.domain.ReportHolder;
import com.xebialabs.xltest.domain.TestRun;
import com.xebialabs.xltest.domain.TestSpecification;
import com.xebialabs.xltest.domain.TestSpecificationSet;
import com.xebialabs.xltest.domain.TestTool;
import com.xebialabs.xltest.repository.NotFoundException;
import com.xebialabs.xltest.repository.TestRunsRepository;
import com.xebialabs.xltest.repository.TestTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/testspecifications")
@Produces(value={"application/json"})
public class TestSpecificationController {
    private static final Logger LOG = LoggerFactory.getLogger(TestSpecificationController.class);
    private final RepositoryService repositoryService;
    private final TestTools testTools;
    private final TestRunsRepository testRunsRepository;

    @Autowired
    public TestSpecificationController(RepositoryService repositoryService, TestTools testTools, TestRunsRepository testRunsRepository) {
        this.repositoryService = repositoryService;
        this.testTools = testTools;
        this.testRunsRepository = testRunsRepository;
    }

    @GET
    @Path(value="/{testSpecificationName:.+}/dashboard")
    public BaseConfigurationItem findDashboardForTestSpecification(@PathParam(value="testSpecificationName") String testSpecificationName, @QueryParam(value="runId") String runId) {
        TestSpecification testSpecification = null;
        try {
            testSpecification = (TestSpecification)this.repositoryService.read("Configuration/TestSpecifications/" + testSpecificationName);
        }
        catch (NotFoundException nfe) {
            LOG.warn("Could not find TestSpecifications named: " + testSpecificationName + ". I will just tell the user and will not deliver any dashboard");
        }
        if (testSpecification == null) {
            return null;
        }
        String testToolName = (String)testSpecification.getProperty("testToolName");
        TestTool testTool = this.testTools.findByName(testToolName);
        Dashboard dashboard = this.getRelevantDashboard(testTool);
        if (dashboard != null) {
            dashboard.setTestSpecification(testSpecification);
            this.provideReportUrlsToDashboard(testSpecification, dashboard, runId);
        }
        return dashboard;
    }

    private void provideReportUrlsToDashboard(TestSpecification testSpecification, Dashboard dashboard, String runId) {
        if (dashboard.getReportHolders() == null) {
            return;
        }
        TestRun testRun = null;
        if (runId != null && !"".equals(runId)) {
            testRun = this.testRunsRepository.getTestRun(runId);
        } else {
            HashMap<String, String> query = new HashMap<String, String>();
            query.put("testSpecification", testSpecification.getName());
            List testRuns = this.testRunsRepository.getTestRuns(query);
            if (!testRuns.isEmpty()) {
                testRun = (TestRun)testRuns.get(0);
            }
        }
        if (testRun != null) {
            dashboard.setDate(testRun.getStartTime());
            for (ReportHolder holder : dashboard.getReportHolders()) {
                holder.setTestRunId(testRun.getId());
                if (!testSpecification.hasProperty("showCaseData")) continue;
                holder.setShowCaseData((Boolean)testSpecification.getProperty("showCaseData"));
            }
        }
    }

    private Dashboard getRelevantDashboard(TestTool testTool) {
        String toolCategory = testTool.getCategory();
        SearchParameters query = new SearchParameters().setType(Type.valueOf(Dashboard.class));
        List allDashboards = this.repositoryService.listEntities(query);
        for (Dashboard dashboard : allDashboards) {
            List<String> toolCategories = dashboard.getToolCategories();
            if (!toolCategories.contains(toolCategory)) continue;
            return (Dashboard)this.repositoryService.read(dashboard.getId());
        }
        return null;
    }

    @DELETE
    @Path(value="/{testSpecificationName:.+}")
    public void deleteTestSpecification(@PathParam(value="testSpecificationName") String testSpecificationName) {
        LOG.info("removing test specification:" + testSpecificationName);
        String testSpecificationId = "Configuration/TestSpecifications/" + testSpecificationName;
        SearchParameters query = new SearchParameters().setType(Type.valueOf(BaseTestSpecification.class));
        List allTestSpecifications = this.repositoryService.listEntities(query);
        this.removeIncludingReferences(testSpecificationId, allTestSpecifications);
        LOG.info("removed test specification:" + testSpecificationName);
    }

    @DELETE
    @Path(value="/{testSpecificationName:.+}/{testSpecificationParentName:.+}")
    public void deleteTestSpecificationReferenceFromParent(@PathParam(value="testSpecificationName") String testSpecificationName, @PathParam(value="testSpecificationParentName") String testSpecificationParentName) {
        String testSpecificationId = "Configuration/TestSpecifications/" + testSpecificationName;
        ConfigurationItem testSpecification = this.repositoryService.read(testSpecificationId);
        String testSpecificationParentId = "Configuration/TestSpecifications/" + testSpecificationParentName;
        TestSpecificationSet testSpecificationParent = (TestSpecificationSet)this.repositoryService.read(testSpecificationParentId);
        ArrayList<BaseTestSpecification> newListOfChildren = new ArrayList<BaseTestSpecification>();
        if (testSpecification != null && testSpecificationParent != null) {
            boolean referencePresent = false;
            for (BaseTestSpecification testSpec : testSpecificationParent.getTestSpecifications()) {
                if (testSpec.getId().equals(testSpecificationId)) {
                    referencePresent = true;
                    continue;
                }
                newListOfChildren.add(testSpec);
            }
            if (referencePresent) {
                testSpecificationParent.setTestSpecifications(newListOfChildren);
                this.repositoryService.createOrUpdate((ConfigurationItem[])new TestSpecificationSet[]{testSpecificationParent});
            }
        }
    }

    private void removeIncludingReferences(String testSpecificationId, List<BaseTestSpecification> allTestSpecifications) {
        for (BaseTestSpecification testSpec : allTestSpecifications) {
            if (!(testSpec instanceof TestSpecificationSet)) continue;
            this.removeTestSpecificationReferenceFromSuperSetsRecursively(testSpecificationId, (TestSpecificationSet)testSpec);
        }
        this.repositoryService.delete(new String[]{testSpecificationId});
    }

    private void removeTestSpecificationReferenceFromSuperSetsRecursively(String testSpecificationId, TestSpecificationSet testSetSpec) {
        ArrayList<BaseTestSpecification> newListOfChildren = new ArrayList<BaseTestSpecification>();
        boolean referencePresent = false;
        for (BaseTestSpecification testSpec : testSetSpec.getTestSpecifications()) {
            if (testSpec.getId().equals(testSpecificationId)) {
                referencePresent = true;
                continue;
            }
            newListOfChildren.add(testSpec);
            if (!(testSpec instanceof TestSpecificationSet)) continue;
            this.removeTestSpecificationReferenceFromSuperSetsRecursively(testSpecificationId, (TestSpecificationSet)testSpec);
        }
        if (referencePresent) {
            testSetSpec.setTestSpecifications(newListOfChildren);
            this.repositoryService.createOrUpdate((ConfigurationItem[])new TestSpecificationSet[]{testSetSpec});
        }
    }

    @GET
    @Path(value="/")
    public String treeForTestSpecification() throws JSONException {
        SearchParameters query = new SearchParameters().setType(Type.valueOf(BaseTestSpecification.class));
        List<BaseTestSpecification> allTestSpecifications = this.repositoryService.listEntities(query);
        if (allTestSpecifications == null) {
            allTestSpecifications = Collections.emptyList();
        }
        return this.createTestSpecificationTree(allTestSpecifications).toString();
    }

    protected JSONArray createTestSpecificationTree(List<BaseTestSpecification> allTestSpecifications) throws JSONException {
        return this.createTestSpecificationTree(allTestSpecifications, null);
    }

    protected JSONArray createTestSpecificationTree(List<BaseTestSpecification> allTestSpecifications, BaseTestSpecification parent) throws JSONException {
        JSONArray jArray = new JSONArray();
        for (BaseTestSpecification testSpec : allTestSpecifications) {
            JSONObject child = new JSONObject();
            child.put("name", (Object)testSpec.getName());
            child.put("type", (Object)testSpec.getType());
            if (parent != null) {
                child.put("parent", (Object)parent.getName());
            }
            if (testSpec.hasProperty("testToolName")) {
                child.put("testToolName", testSpec.getProperty("testToolName"));
            }
            child.put("executable", testSpec instanceof Executable && ((Executable)((Object)testSpec)).isExecutable());
            if (testSpec.hasProperty("testSpecifications")) {
                List children = (List)testSpec.getProperty("testSpecifications");
                child.put("testSpecifications", (Object)this.createTestSpecificationTree(children, testSpec));
            }
            jArray.put((Object)child);
        }
        return jArray;
    }
}

