/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.resources;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xltest.domain.TestSpecification;
import com.xebialabs.xltest.domain.TestTool;
import com.xebialabs.xltest.repository.TestSpecificationRepository;
import com.xebialabs.xltest.repository.TestTools;
import com.xebialabs.xltest.service.TestResultLocator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/testtools")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class TestToolsController {
    private static final Logger LOG = LoggerFactory.getLogger(TestToolsController.class);
    private final TestTools testTools;
    private final TestSpecificationRepository testSpecifications;

    @Autowired
    public TestToolsController(TestTools testTools, TestSpecificationRepository testSpecifications) {
        this.testTools = testTools;
        this.testSpecifications = testSpecifications;
    }

    @GET
    public Response getTestTools() {
        JSONArray json = new JSONArray();
        for (TestTool testTool : this.testTools.getTestTools()) {
            JSONObject tool = new JSONObject();
            tool.put((Object)"name", (Object)testTool.getName());
            tool.put((Object)"pattern", (Object)testTool.getSearchPattern());
            json.add((Object)tool);
        }
        return Response.ok((Object)json.toString()).build();
    }

    @GET
    @Path(value="{testTool}/paths")
    public Response validateHostConfiguration(@PathParam(value="testTool") String testTool, @QueryParam(value="type") String type, @QueryParam(value="address") String address, @QueryParam(value="username") String username, @QueryParam(value="password") String password, @QueryParam(value="path") String path, @QueryParam(value="pattern") String pattern, @QueryParam(value="jobName") String jobName) {
        JSONObject json;
        Collection<OverthereFile> files;
        Response urlVerify;
        List<TestSpecification> testSpecificationsWithHost = this.testSpecifications.findWithHost(testTool, pattern, address, path, -1, type);
        if (type.equals("overthere.JenkinsHost") && (urlVerify = this.verifyJenkinsUrl(address)) != null) {
            return urlVerify;
        }
        try {
            files = new TestResultLocator(this.testTools).forHost(type, address, username, password, jobName).forTestTool(testTool).locate(path, pattern);
        }
        catch (Exception e) {
            LOG.info("Unable to validate host configuration. Type: {}, address: {}, username: {}, path: {}, testtool: {}", new Object[]{type, address, username, path, testTool, e});
            JSONObject json2 = new JSONObject();
            json2.put((Object)"error", (Object)e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)json2.toString()).build();
        }
        if (files != null && !files.isEmpty()) {
            json = new JSONObject();
            JSONArray paths = new JSONArray();
            json.put((Object)"paths", (Object)paths);
            for (OverthereFile file : files) {
                paths.add((Object)file.getPath());
            }
            JSONArray testSpecificationsJson = new JSONArray();
            json.put((Object)"testSpecifications", (Object)testSpecificationsJson);
            for (TestSpecification testSpecification : testSpecificationsWithHost) {
                testSpecificationsJson.add((Object)testSpecification.getName());
            }
            return Response.ok((Object)json.toString()).build();
        }
        json = new JSONObject();
        json.put((Object)"error", (Object)String.format("No test results found in path %s", path));
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)json.toString()).build();
    }

    private Response verifyJenkinsUrl(String url) {
        try {
            URL addressUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            JSONObject json = new JSONObject();
            json.put((Object)"error", (Object)("Could not parse Jenkins URL: " + e.getMessage()));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)json.toString()).build();
        }
        return null;
    }
}

