/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.serialize;

import com.jayway.jsonpath.spi.JsonProviderFactory;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.serialize.BasicMessageBodyReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.codehaus.jettison.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Provider
@Consumes(value={"application/json"})
public class EventReader
extends BasicMessageBodyReader<Event> {
    Logger LOG = LoggerFactory.getLogger(EventReader.class);

    @Override
    public boolean isReadable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return Event.class.isAssignableFrom(aClass);
    }

    @Override
    public Event readJson(String json) throws JSONException {
        this.LOG.debug("Reading event: " + json);
        Map object = (Map)JsonProviderFactory.createProvider().parse(json);
        String type = (String)object.get("type");
        return new Event(type != null ? type : "UNKNOWN", object);
    }
}

