/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.repository.JcrQueryTemplate;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.internal.Root;
import com.xebialabs.xltest.domain.TestRun;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryRepositoryService
implements RepositoryService,
Serializable {
    private Map<String, ConfigurationItem> store = Maps.newHashMap();
    private static Logger LOG = LoggerFactory.getLogger(InMemoryRepositoryService.class);

    public InMemoryRepositoryService() {
        this.store.put("Applications", Type.valueOf(Root.class).getDescriptor().newInstance("Applications"));
    }

    public boolean exists(String id) {
        return this.store.containsKey(id);
    }

    public <T extends ConfigurationItem> T read(String id) {
        ConfigurationItem ci = this.store.get(id);
        return (T)this.defensiveCopy(ci);
    }

    private <T extends ConfigurationItem> T defensiveCopy(T ci) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            new ObjectOutputStream(bytes).writeObject(ci);
            ConfigurationItem copiedObject = (ConfigurationItem)new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray())).readObject();
            return (T)copiedObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public <T extends ConfigurationItem> T read(String id, WorkDir workDir) {
        return this.read(id);
    }

    public <T extends ConfigurationItem> void create(T ... entities) {
        this.checkThatEntitiesDoNotExist((ConfigurationItem[])entities);
        this.storeEntities((ConfigurationItem[])entities);
    }

    private void checkThatEntitiesDoNotExist(ConfigurationItem[] entities) {
        for (ConfigurationItem entity : entities) {
            if (!this.store.containsKey(entity.getId())) continue;
            throw new IllegalStateException("Entity " + entity.getId() + " already exists and cannot be created twice.");
        }
    }

    private void storeEntities(ConfigurationItem[] entities) {
        for (ConfigurationItem entity : entities) {
            this.store.put(entity.getId(), this.defensiveCopy(entity));
        }
    }

    public <T extends ConfigurationItem> void update(T ... entities) {
        for (T entity : entities) {
            T defensiveCopy = this.defensiveCopy(entity);
            if (entity instanceof TestRun) {
                TestRun tr = (TestRun)entity;
                TestRun copiedTr = (TestRun)defensiveCopy;
            }
            this.store.put(entity.getId(), (ConfigurationItem)defensiveCopy);
        }
    }

    public <T extends ConfigurationItem> void move(String id, String newId) {
        ConfigurationItem remove = this.store.remove(id);
        remove.setId(newId);
        this.store.put(newId, this.defensiveCopy(remove));
    }

    public <T extends ConfigurationItem> void copy(String id, String newId) {
        ConfigurationItem itemToCopy = this.store.get(id);
        ConfigurationItem copiedItem = this.defensiveCopy(itemToCopy);
        copiedItem.setId(newId);
        this.store.put(newId, copiedItem);
    }

    public <T extends ConfigurationItem> void createOrUpdate(T ... entities) {
        for (T entity : entities) {
            this.store.put(entity.getId(), (ConfigurationItem)this.defensiveCopy(entity));
        }
    }

    public void rename(String id, String newName) {
        ConfigurationItem remove = this.store.remove(id);
        remove.setId(id.substring(0, id.lastIndexOf(47) + 1) + newName);
        this.store.put(remove.getId(), remove);
    }

    public void delete(String ... ids) {
        for (String id : ids) {
            this.store.remove(id);
        }
    }

    public void execute(ChangeSet batchUpdate) {
        if (!batchUpdate.getCreateCis().isEmpty()) {
            this.create(batchUpdate.getCreateCis().toArray(new ConfigurationItem[batchUpdate.getCreateCis().size()]));
        }
        if (!batchUpdate.getCreateOrUpdateCis().isEmpty()) {
            this.createOrUpdate(batchUpdate.getCreateOrUpdateCis().toArray(new ConfigurationItem[batchUpdate.getCreateOrUpdateCis().size()]));
        }
        if (!batchUpdate.getUpdateCis().isEmpty()) {
            this.update(batchUpdate.getUpdateCis().toArray(new ConfigurationItem[batchUpdate.getUpdateCis().size()]));
        }
        if (!batchUpdate.getDeleteCiIds().isEmpty()) {
            this.delete(batchUpdate.getDeleteCiIds().toArray(new String[batchUpdate.getDeleteCiIds().size()]));
        }
    }

    public List<ConfigurationItemData> list(SearchParameters criteria) {
        ArrayList ids = Lists.newArrayList();
        if (this.getType(criteria) != null) {
            for (ConfigurationItem configurationItem : this.store.values()) {
                if (!configurationItem.getType().equals((Object)this.getType(criteria))) continue;
                ids.add(new ConfigurationItemData(configurationItem.getId(), configurationItem.getType()));
            }
            return ids;
        }
        throw new UnsupportedOperationException("Input error?");
    }

    public <T extends ConfigurationItem> List<T> listEntities(SearchParameters criteria) {
        ArrayList ids = Lists.newArrayList();
        Type criteriaType = this.getType(criteria);
        if (criteriaType != null) {
            for (ConfigurationItem configurationItem : this.store.values()) {
                if (!configurationItem.getType().instanceOf(criteriaType)) continue;
                ids.add(configurationItem);
            }
            return ids;
        }
        throw new UnsupportedOperationException("Input error?");
    }

    public List<ConfigurationItemData> list(JcrQueryTemplate queryTemplate) {
        throw new UnsupportedOperationException("InMemoryRepositoryService.list() not implemented");
    }

    public <T extends ConfigurationItem> List<T> listEntities(JcrQueryTemplate queryTemplate) {
        throw new UnsupportedOperationException("InMemoryRepositoryService.listEntities() not implemented");
    }

    public void checkReferentialIntegrity(ChangeSet batchUpdate) throws ItemInUseException {
    }

    public <T extends ConfigurationItem> T read(String id, boolean useCache) {
        return this.read(id);
    }

    public <T extends ConfigurationItem> T read(String id, WorkDir workDir, boolean useCache) {
        return this.read(id);
    }

    Type getType(SearchParameters criteria) {
        return criteria.getType();
    }

    public <T extends ConfigurationItem> T read(String id, int depth) {
        return null;
    }

    public <T extends ConfigurationItem> T read(String id, int depth, WorkDir workDir, boolean useCache) {
        return null;
    }
}

