
import re

def nameStartsWithPrefix(prefix, ev):
    if prefix is None or prefix == '':
        return True
    name = ev.get('name')
    return re.match('^' + prefix[:-1] + '\W', name)
	
def nextWordAfterPrefix(prefix, name):
    return re.split('\.|;', name[len(prefix):])[0] or ''

def countDots(prefix):
    return len(prefix.split('.')) - 1

id = testRun.getTestRunId()

team = queryParameters['team'] or ''
if team == '':
    events = testRun.getEvents()
else:
    team = str(team)
    events = testRun.getEvents({'team':team})

if events:
    passed = {}
    failed = {}
    prefix = queryParameters['prefix'] or ''
    team = queryParameters['team'] or ''
    if prefix == '':
        rotation = 0
    else:
        rotation = -45
    level = countDots(prefix)
    for ev in events:
        if ev.type == 'functionalResult' and nameStartsWithPrefix(prefix, ev):
            p = ev.getProperties()
            if team == '':
                x = str(p.get('team'))
            else:
                x = nextWordAfterPrefix(prefix, p.get('name'))
            result = p.get('result')
            if x is None:
                continue
            if result == 'PASSED':
                passed.setdefault(x, []).append(1)
            else:
                failed.setdefault(x, []).append(1)

    xs = sorted(set(failed.keys() + passed.keys()))

    def make_column_values(group_map, groups, team):
        if team == '':
            return map(lambda t: group_map.has_key(t) and { 'y': sum(group_map[t]), 'params': 'team=%s' % (t) } or None, groups)
        else:
            return map(lambda t: group_map.has_key(t) and { 'y': sum(group_map[t]), 'params': 'team=%s&prefix=%s%s;' % (team, prefix, t) } or None, groups)

    passed = make_column_values(passed, xs, team)
    failed = make_column_values(failed, xs, team)
    xs = map(lambda x: x[:20], xs)
    
    if team == '':
        title = 'Test result overview Per Team at level %s' % level
    else:
        title = 'Test result overview for Team %s at level %s' % (team, level)
    if xs == []:
        title = 'No drilldown available at level %s' % level


    resultHolder.setResult(
        {
            'chart': {
                'type': 'column',
                'animation': False
            },
            'title': {
                'text': title
            },
            'xAxis': {
                'categories': xs,
                'labels': {
                    'rotation': rotation,
                }
            },
            'yAxis': {
                'min': 0,
                'title': {
                    'text': 'Total tests'
                },
                'stackLabels': {
                    'enabled': True
                },
                'minTickInterval': 1
            },
            'colors': ['#9ADA7F', '#FD8D10', '#055F75', '#E36C16', '#009190'],
            'plotOptions': {
                'column': {
                    'animation': False,
                    'cursor': 'pointer',
                    'stacking': 'normal',
                    'dataLabels': {
                        'enabled': True,
                        'color': 'white'
                    }
                },
                'series':  {
                    'point': {
                        'events': {
                            'click': 'url'
                        }
                    }
                } or None
            },
            'credits': {
                'enabled': False
            },
            "series": [{
                           "name": "Passed",
                           "data": passed
                       },
                       {
                           "name": "Failed",
                           "data": failed
                       }]
        })

