/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.repository;

import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.TestRun;
import com.xebialabs.xltest.repository.NoTestRunFoundException;
import com.xebialabs.xltest.repository.TestRunsRepository;
import com.xebialabs.xltest.service.EventRepository;
import com.xebialabs.xltest.utils.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class TestRunsRepositoryImpl
implements TestRunsRepository {
    private static Logger LOG = LoggerFactory.getLogger(TestRunsRepository.class);
    private final EventRepository eventRepository;
    private static final Set<String> standardProps = new HashSet<String>(Arrays.asList("timestamp", "testSpecification", "runId", "type"));

    @Autowired
    public TestRunsRepositoryImpl(EventRepository eventRepository) {
        this.eventRepository = eventRepository;
    }

    public TestRun getTestRun(String testRunId) {
        return this.getTestRun(UUID.fromString(testRunId));
    }

    public TestRun getTestRun(UUID testRunId) {
        TestRun tempTestRun = new TestRun(testRunId);
        tempTestRun.setEventRepository(this.eventRepository);
        Event executionStartedEvent = this.getEventFromTestRun(tempTestRun, "executionStarted");
        Event importStartedEvent = this.getEventFromTestRun(tempTestRun, "importStarted");
        Event importFinishedEvent = this.getEventFromTestRun(tempTestRun, "importFinished");
        Event executionFinishedEvent = this.getEventFromTestRun(tempTestRun, "executionFinished");
        Event qualificationEvent = this.getEventFromTestRun(tempTestRun, "qualificationComputed");
        TestRun testRun = this.createTestRun(testRunId, executionStartedEvent, importStartedEvent, importFinishedEvent, executionFinishedEvent, qualificationEvent);
        testRun.setEventRepository(this.eventRepository);
        return testRun;
    }

    public TestRun getTestRunFromEvents(List<Event> events) {
        Event executionStartedEvent = null;
        Event executionFinishedEvent = null;
        Event importStartedEvent = null;
        Event importFinishedEvent = null;
        Event qualificationEvent = null;
        UUID testRunId = null;
        for (Event event : events) {
            String type = event.getType();
            if (testRunId == null) {
                testRunId = event.getTestRunId();
            }
            if ("executionStarted".equals(type) && executionStartedEvent == null) {
                executionStartedEvent = event;
                continue;
            }
            if ("executionFinished".equals(type)) {
                executionFinishedEvent = event;
                continue;
            }
            if ("importStarted".equals(type) && importStartedEvent == null) {
                importStartedEvent = event;
                continue;
            }
            if ("importFinished".equals(type)) {
                importFinishedEvent = event;
                continue;
            }
            if (!"qualificationComputed".equals(type)) continue;
            qualificationEvent = event;
        }
        return this.createTestRun(testRunId, executionStartedEvent, importStartedEvent, importFinishedEvent, executionFinishedEvent, qualificationEvent);
    }

    private Event getEventFromTestRun(TestRun testRun, String eventType) {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        queryParameters.put("type", eventType);
        List events = testRun.getEvents(queryParameters);
        if (events != null && events.size() >= 1) {
            return (Event)events.get(0);
        }
        return null;
    }

    public Collection<TestRun> getAllTestRuns() {
        return this.getTestRuns(Collections.emptyMap());
    }

    private String constructQuery(long startTime, long endTime, Map queryParameters) {
        return this.constructSearchQuery("timestamp:>=" + startTime + " AND timestamp:<=" + endTime, queryParameters);
    }

    private String constructSearchQuery(String query, Map queryParameters) {
        for (Object key : queryParameters.keySet()) {
            String value = (String)queryParameters.get(key);
            query = query + " AND " + key + ":\"" + value + "\"";
        }
        return query;
    }

    private List<Event> getEventsBetweenByType(long startTime, long endTime, String eventType, Map queryParameters) {
        HashMap<String, String> startTestRunQuery = new HashMap<String, String>(queryParameters);
        startTestRunQuery.put("type", eventType);
        String query = this.constructQuery(startTime, endTime, startTestRunQuery);
        LOG.info("Querying ES with: {} for events in a timerange filtered by query params", (Object)query);
        return this.eventRepository.query(query);
    }

    public List<TestRun> getTestRuns(Map queryParameters) {
        int startTime = 0;
        long endTime = System.currentTimeMillis();
        return this.getTestRuns(queryParameters, startTime, endTime);
    }

    public List<TestRun> getTestRunsBetween(long startTime, long endTime) {
        return this.getTestRuns(Collections.emptyMap(), Math.min(startTime, endTime), Math.max(startTime, endTime));
    }

    public List<TestRun> getTestRuns(Map queryParameters, long startTime, long endTime) {
        List<Event> allStartEventsAsList = this.getEventsBetweenByType(startTime, endTime, "executionStarted", queryParameters);
        Map<UUID, Event> startEvents = this.getAllEventsAsMap(allStartEventsAsList);
        List<Event> allImportStartedEvents = this.getEventsBetweenByType(startTime, endTime, "importStarted", queryParameters);
        Map<UUID, Event> importStartedEvents = this.getAllEventsAsMap(allImportStartedEvents);
        List<Event> allImportFinishedEvents = this.getEventsBetweenByType(startTime, endTime, "importFinished", queryParameters);
        Map<UUID, Event> importFinishedEvents = this.getAllEventsAsMap(allImportFinishedEvents);
        List<Event> allFinishTestRunEvents = this.getEventsBetweenByType(startTime, endTime, "executionFinished", queryParameters);
        Map<UUID, Event> finishTestRunEvents = this.getAllEventsAsMap(allFinishTestRunEvents);
        List<Event> allQualificationEvents = this.getEventsBetweenByType(startTime, endTime, "qualificationComputed", queryParameters);
        Map<UUID, Event> qualificationEvents = this.getAllEventsAsMap(allQualificationEvents);
        Set<UUID> allUuids = this.getAllUuids(startEvents, importStartedEvents);
        ArrayList<TestRun> testRuns = new ArrayList<TestRun>();
        for (UUID uuid : allUuids) {
            Event startEvent = startEvents.get(uuid);
            Event importStarted = importStartedEvents.get(uuid);
            Event importFinished = importFinishedEvents.get(uuid);
            Event finishTestRunEvent = finishTestRunEvents.get(uuid);
            Event qualificationEvent = qualificationEvents.get(uuid);
            TestRun testRun = this.createTestRun(uuid, startEvent, importStarted, importFinished, finishTestRunEvent, qualificationEvent);
            testRun.setEventRepository(this.eventRepository);
            testRuns.add(testRun);
        }
        Collections.sort(testRuns, new Comparator<TestRun>(){

            @Override
            public int compare(TestRun o1, TestRun o2) {
                Date startTime1 = o1.getStartTime() != null ? o1.getStartTime() : new Date(0L);
                Date startTime2 = o2.getStartTime() != null ? o2.getStartTime() : new Date(0L);
                return startTime2.compareTo(startTime1);
            }
        });
        return testRuns;
    }

    private Set<UUID> getAllUuids(Map<UUID, Event> startEvents, Map<UUID, Event> importStartedEvents) {
        HashSet<UUID> allUuids = new HashSet<UUID>();
        allUuids.addAll(startEvents.keySet());
        allUuids.addAll(importStartedEvents.keySet());
        return allUuids;
    }

    private Map<UUID, Event> getAllEventsAsMap(List<Event> events) {
        HashMap<UUID, Event> map = new HashMap<UUID, Event>();
        for (Event ev : events) {
            map.put(ev.getTestRunId(), ev);
        }
        return map;
    }

    private TestRun createTestRun(UUID uuid, Event startEvent, Event importStartedEvent, Event importFinishedEvent, Event finishEvent, Event qualificationEvent) {
        TestRun testRun = new TestRun(uuid);
        if (startEvent != null) {
            testRun.setTestSpecificationName((String)startEvent.get("testSpecification"));
            testRun.setStartTime(new Date(((Number)startEvent.get("timestamp")).longValue()));
        } else if (importStartedEvent != null) {
            testRun.setTestSpecificationName((String)importStartedEvent.get("testSpecification"));
            testRun.setStartTime(new Date(((Number)importStartedEvent.get("lastModified")).longValue()));
        } else {
            throw new NoTestRunFoundException("Can't populate TestRun from these executionStarted or importStarted events. Both could not be found");
        }
        if (finishEvent != null && finishEvent.get("timestamp") != null) {
            testRun.setFinishedTime(new Date(((Number)finishEvent.get("timestamp")).longValue()));
        } else if (importFinishedEvent != null && importFinishedEvent.get("timestamp") != null) {
            testRun.setFinishedTime(new Date(((Number)importFinishedEvent.get("timestamp")).longValue()));
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (startEvent != null) {
            for (String key : startEvent.getProperties().keySet()) {
                if (standardProps.contains(key)) continue;
                parameters.put(key, startEvent.get(key));
            }
        }
        if (finishEvent != null) {
            for (String key : finishEvent.getProperties().keySet()) {
                if (standardProps.contains(key)) continue;
                parameters.put(key, finishEvent.get(key));
            }
        }
        testRun.setParameters(parameters);
        if (qualificationEvent != null) {
            testRun.setQualificationResult(((Boolean)qualificationEvent.get("qualification")).booleanValue());
            String failureReason = "";
            if (qualificationEvent.hasProperty("failureReason")) {
                failureReason = (String)qualificationEvent.get("failureReason");
            }
            testRun.setFailureReason(failureReason);
        }
        return testRun;
    }

    public List<TestRun> getPreviousRuns(TestRun testRun, int max) {
        return this.getSimilarRunsSortedInTime(testRun, max, this.getReverseComparator(), true);
    }

    public List<TestRun> getLaterRuns(TestRun testRun, int max) {
        return this.getSimilarRunsSortedInTime(testRun, max, this.getNormalComparator(), false);
    }

    public List<Event> getEventsBetween(long startTime, long endTime, Map<String, Object> eventProperties) {
        String query = this.constructQuery(startTime, endTime, eventProperties);
        return this.eventRepository.query(query);
    }

    public Date parseDateString(String dateString) {
        if (StringUtils.hasText((String)dateString)) {
            try {
                DateTime dateTime = new DateTime(Long.parseLong(dateString));
                return dateTime.withTimeAtStartOfDay().toDate();
            }
            catch (Exception e) {
                LOG.error("Unable to convert dateString (expected to be timestamp) [" + dateString + "] into Date.");
            }
        }
        return null;
    }

    public Date makeStartDateIfProvided(String dateString) {
        Date result = this.parseDateString(dateString);
        if (result == null) {
            result = new DateTime().minusWeeks(2).withTimeAtStartOfDay().toDate();
        }
        return result;
    }

    public Date makeEndDateIfProvided(String dateString) {
        Date result = this.parseDateString(dateString);
        if (result == null) {
            result = new Date();
        }
        return result;
    }

    private List<TestRun> getSimilarRunsSortedInTime(TestRun testRun, int max, Comparator<TestRun> comparator, boolean before) {
        Collection<TestRun> allTestRuns = this.getAllTestRuns();
        String testSpecificationId = testRun.getTestSpecificationName();
        ArrayList<TestRun> allTestRunsWithTheSameReference = new ArrayList<TestRun>();
        for (TestRun tr : allTestRuns) {
            if (!testSpecificationId.equals(tr.getTestSpecificationName())) continue;
            allTestRunsWithTheSameReference.add(tr);
        }
        Collections.sort(allTestRunsWithTheSameReference, comparator);
        ArrayList<TestRun> similarRunsSortedInTime = new ArrayList<TestRun>();
        Date startTime = testRun.getStartTime();
        int cnt = 0;
        for (TestRun tr : allTestRunsWithTheSameReference) {
            if (this.beforeOrAfter(startTime, tr, before)) {
                similarRunsSortedInTime.add(tr);
                ++cnt;
            }
            if (cnt < max) continue;
            break;
        }
        LOG.debug("I got " + similarRunsSortedInTime.size() + " similar runs");
        return similarRunsSortedInTime;
    }

    private boolean beforeOrAfter(Date startTime, TestRun testRun, boolean before) {
        if (before) {
            return testRun.getStartTime().before(startTime);
        }
        return testRun.getStartTime().after(startTime);
    }

    private Comparator<TestRun> getNormalComparator() {
        Comparator<TestRun> comparator = new Comparator<TestRun>(){

            @Override
            public int compare(TestRun r1, TestRun r2) {
                return r1.getStartTime().compareTo(r2.getStartTime());
            }
        };
        return comparator;
    }

    private Comparator<TestRun> getReverseComparator() {
        Comparator<TestRun> comparator = new Comparator<TestRun>(){

            @Override
            public int compare(TestRun r1, TestRun r2) {
                return r2.getStartTime().compareTo(r1.getStartTime());
            }
        };
        return comparator;
    }

    public List<Event> getCorrespondingEventsFromOlderRuns(TestRun testRun, Event event, int max, String ... matchingProperties) {
        ArrayList<Event> events = new ArrayList<Event>();
        List<TestRun> previousRuns = this.getPreviousRuns(testRun, max);
        LOG.debug("While getting events from max " + max + " previous Runs, I got " + previousRuns.size() + " such runs");
        Map queryParameters = this.makeQueryParameters(event, matchingProperties);
        for (TestRun previousRun : previousRuns) {
            List eventsOfPreviousRun = previousRun.getEvents(queryParameters);
            LOG.debug("Found " + eventsOfPreviousRun.size() + " events with matching properties in a previous run");
            events.addAll(eventsOfPreviousRun);
        }
        LOG.debug("Found " + events.size() + " CorrespondingEventsFromOlderRuns.");
        return events;
    }

    private Map makeQueryParameters(Event event, String ... matchingProperties) {
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        if (matchingProperties != null && matchingProperties.length != 0) {
            for (int i = 0; i < matchingProperties.length; ++i) {
                String propertyKey = matchingProperties[i];
                queryParameters.put(propertyKey, event.get(propertyKey));
            }
        }
        return queryParameters;
    }

    public List<TestRun> getPreviousRunsIncludingThisOne(TestRun testRun, int max) {
        List<TestRun> runs = this.getPreviousRuns(testRun, max);
        runs.add(testRun);
        return runs;
    }

    public List<Event> getCorrespondingEventsFromOtherRuns(Event event, List<TestRun> otherRuns, String ... matchingProperties) {
        ArrayList<Event> events = new ArrayList<Event>();
        Map queryParameters = this.makeQueryParameters(event, matchingProperties);
        for (TestRun previousRun : otherRuns) {
            List eventsOfPreviousRun = previousRun.getEvents(queryParameters);
            LOG.debug("Found " + eventsOfPreviousRun.size() + " events with matching properties in a previous run");
            events.addAll(eventsOfPreviousRun);
        }
        LOG.debug("Found " + events.size() + " CorrespondingEventsFromOlderRuns");
        return events;
    }

    public Map<String, List<Event>> getEventsFromRunsAsMapGroupedBy(String mapProperty, List<TestRun> runs, String ... matchingKVs) {
        Map<String, Object> properties = this.makeEventProperties(matchingKVs);
        Set<String> keySet = properties.keySet();
        String[] matchingProperties = keySet.toArray(new String[keySet.size()]);
        Event event = new Event(properties);
        List<Event> allEvents = this.getCorrespondingEventsFromOtherRuns(event, runs, matchingProperties);
        HashMap<String, List<Event>> map = new HashMap<String, List<Event>>();
        for (Event e : allEvents) {
            String groupByValue = (String)e.get(mapProperty);
            if (map.get(groupByValue) == null) {
                map.put(groupByValue, new ArrayList());
            }
            ((List)map.get(groupByValue)).add(e);
        }
        return this.orderEventsByTimeStampNewestOnTop(map);
    }

    public Map<String, List<Event>> getEventsFromRunsAsMapGroupedBy(String mapProperty, int level, List<TestRun> runs, String ... matchingKVs) {
        Map<String, Object> properties = this.makeEventProperties(matchingKVs);
        Set<String> keySet = properties.keySet();
        String[] matchingProperties = keySet.toArray(new String[keySet.size()]);
        Event event = new Event(properties);
        List<Event> allEvents = this.getCorrespondingEventsFromOtherRuns(event, runs, matchingProperties);
        HashMap<String, List<Event>> map = new HashMap<String, List<Event>>();
        for (Event e : allEvents) {
            String groupByValue = this.cutAtLevel((String)e.get(mapProperty), level);
            if (map.get(groupByValue) == null) {
                map.put(groupByValue, new ArrayList());
            }
            ((List)map.get(groupByValue)).add(e);
        }
        return this.orderEventsByTimeStampNewestOnTop(map);
    }

    private Map<String, List<Event>> orderEventsByTimeStampNewestOnTop(Map<String, List<Event>> map) {
        for (String key : map.keySet()) {
            Collections.sort(map.get(key), new Comparator<Event>(){

                @Override
                public int compare(Event r1, Event r2) {
                    Comparable t1 = null;
                    Comparable t2 = null;
                    try {
                        t1 = (Comparable)r1.get("timestamp");
                        t2 = (Comparable)r2.get("timestamp");
                        return t1.compareTo(t2);
                    }
                    catch (Exception e) {
                        LOG.error("t1: {} can't be compared to {}. t1 class: {}", (Object)t1, t2);
                        return 0;
                    }
                }
            });
        }
        return map;
    }

    private String cutAtLevel(String pageName, int level) {
        String[] parts = pageName.split(";");
        if (parts == null || level > parts.length) {
            return pageName;
        }
        int index = 0;
        for (int i = 0; i < level; ++i) {
            index = index + parts[i].length() + 1;
        }
        String result = pageName.substring(0, index);
        if (result.endsWith(";")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private Map<String, Object> makeEventProperties(String[] matchingKVs) {
        HashMap<String, Object> eventProperties = new HashMap<String, Object>();
        for (int i = 0; i < matchingKVs.length; ++i) {
            Pair p = this.parseKV(matchingKVs[i]);
            eventProperties.put(p.getKey(), p.getValue());
        }
        return eventProperties;
    }

    private Pair parseKV(String kv) {
        String key = kv.substring(0, kv.indexOf(58));
        String value = kv.substring(key.length() + 1);
        return new Pair(key, value);
    }
}

