package com.xebialabs.xltest.testtools.fitnesse;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.xlt.plugin.api.resultparser.ImportException;
import com.xebialabs.xlt.plugin.api.testrun.Event;

import fitnesse.reporting.history.SuiteExecutionReport;

import static com.xebialabs.xlt.plugin.api.testrun.Event.RUN_KEY;
import static com.xebialabs.xlt.plugin.api.testrun.Event.TESTED_AT;
import static com.xebialabs.xlt.plugin.api.testrun.Event.TYPE_IMPORT_FINISHED;
import static com.xebialabs.xlt.plugin.api.testrun.Event.TYPE_IMPORT_STARTED;

public class FitNesseSuiteImporter {
    private static final Logger LOG = LoggerFactory.getLogger(FitNesseSuiteImporter.class);

    private FitnesseSuiteImporterFactory fitnesseSuiteImporterFactory;
    private final SuiteExecutionReport executionReport;
    private final String pageName;

    public FitNesseSuiteImporter(FitnesseSuiteImporterFactory fitnesseSuiteImporterFactory, SuiteExecutionReport executionReport, String pageName) {
        this.fitnesseSuiteImporterFactory = fitnesseSuiteImporterFactory;
        this.executionReport = executionReport;
        this.pageName = pageName;
    }

    /**
     * Return the last modified time as a long. Beware: fitnesse does not correct the timestamp for the local time zone.
     * So the value returned is not a proper GMT offset long.
     */
    public long getLastModified() {
        return executionReport.getDate().getTime();
    }

    public String getPageName() {
        return pageName;
    }

    public List<Event> mapSuiteToEvents(String testRunId) throws ImportException {
        LOG.debug("doImport({}, {})", testRunId, pageName);
        List<Event> result = new ArrayList<>();

        result.add(Event.create(TYPE_IMPORT_STARTED, TESTED_AT, getLastModified(), RUN_KEY, Long.toString(getLastModified())));

        try {
            result.addAll(fitnesseSuiteImporterFactory.produceEventsForReport(testRunId, executionReport));
        } finally {
            int duration = (int) executionReport.getTotalRunTimeInMillis();
            result.add(Event.create(TYPE_IMPORT_FINISHED, Event.RUN_ID, testRunId, Event.DURATION, duration));
        }
        return result;
    }

    @Override
    public String toString() {
        return pageName + " " + getLastModified();
    }
}
