/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.entry.Entry;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Iterator;
import java.util.Set;

@DefaultAnnotation(value={NonNull.class})
public abstract class FsEntry
implements Entry {
    @Override
    public abstract String getName();

    public abstract Set<Entry.Type> getTypes();

    public boolean isType(Entry.Type type) {
        return this.getTypes().contains((Object)type);
    }

    @Nullable
    public abstract Set<String> getMembers();

    public final boolean equals(Object that) {
        return this == that;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.getClass().getName()).append("[name=").append(this.getName()).append(",types=");
        Iterator<Entry.Type> i = this.getTypes().iterator();
        while (i.hasNext()) {
            s.append((Object)i.next());
            if (!i.hasNext()) continue;
            s.append('|');
        }
        for (Enum type : ALL_SIZE_SET) {
            s.append(",size(").append(type).append(")=").append(this.getSize((Entry.Size)type));
        }
        for (Enum type : ALL_ACCESS_SET) {
            s.append(",time(").append(type).append(")=").append(this.getTime((Entry.Access)type));
        }
        return s.append(",members=").append(this.getMembers()).append(']').toString();
    }
}

