/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

@DefaultAnnotation(value={NonNull.class})
public class CanonicalStringSet
extends AbstractSet<String> {
    private final Canonicalizer canonicalizer;
    private final char separator;
    private final Set<String> set = new TreeSet<String>();

    public CanonicalStringSet(Canonicalizer canonicalizer, char separator) {
        if (null == canonicalizer) {
            throw new NullPointerException();
        }
        this.canonicalizer = canonicalizer;
        this.separator = separator;
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public Iterator<String> iterator() {
        return this.set.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.set.toArray(array);
    }

    @Override
    public String toString() {
        Iterator<String> i = this.iterator();
        if (i.hasNext()) {
            StringBuilder sb = new StringBuilder();
            int c = 0;
            do {
                String string = i.next();
                if (c++ > 0) {
                    sb.append(this.separator);
                }
                sb.append(string);
            } while (i.hasNext());
            return sb.toString();
        }
        return "";
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return this.set.contains(this.canonicalizer.map(o));
    }

    @Override
    public boolean add(@Nullable String s) {
        return this.set.add(this.canonicalizer.map(s));
    }

    @Override
    public boolean remove(@Nullable Object o) {
        return this.set.remove(this.canonicalizer.map(o));
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    public boolean containsAll(CanonicalStringSet set) {
        return this.set.containsAll(set.set);
    }

    public boolean containsAll(String list) {
        CanonicalStringIterator i = new CanonicalStringIterator(list);
        while (i.hasNext()) {
            if (this.set.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(CanonicalStringSet set) {
        boolean changed = false;
        for (String s : set.set) {
            changed |= this.add(s);
        }
        return changed;
    }

    public boolean addAll(String list) {
        boolean changed = false;
        CanonicalStringIterator i = new CanonicalStringIterator(list);
        while (i.hasNext()) {
            changed |= this.set.add((String)i.next());
        }
        return changed;
    }

    public boolean retainAll(CanonicalStringSet set) {
        return this.set.retainAll(set.set);
    }

    public boolean retainAll(String list) {
        CanonicalStringSet set = new CanonicalStringSet(this.canonicalizer, this.separator);
        set.addAll(list);
        return set.retainAll(set);
    }

    public boolean removeAll(CanonicalStringSet set) {
        return this.set.removeAll(set.set);
    }

    public boolean removeAll(String list) {
        boolean changed = false;
        CanonicalStringIterator i = new CanonicalStringIterator(list);
        while (i.hasNext()) {
            changed |= this.set.remove(i.next());
        }
        return changed;
    }

    private class CanonicalStringIterator
    implements Iterator<String> {
        private final StringTokenizer tokenizer;
        @CheckForNull
        private String canonical;

        private CanonicalStringIterator(String list) {
            this.tokenizer = new StringTokenizer(list, "" + CanonicalStringSet.this.separator);
            this.advance();
        }

        private void advance() {
            while (this.tokenizer.hasMoreTokens()) {
                this.canonical = CanonicalStringSet.this.canonicalizer.map(this.tokenizer.nextToken());
                if (null == this.canonical) continue;
                return;
            }
            this.canonical = null;
        }

        @Override
        public boolean hasNext() {
            return null != this.canonical;
        }

        @Override
        public String next() {
            String canonical = this.canonical;
            if (null == canonical) {
                throw new NoSuchElementException();
            }
            this.advance();
            return canonical;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface Canonicalizer {
        @CheckForNull
        public String map(@Nullable Object var1);
    }
}

