/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.cluster.metadata.AliasAction;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.indices.InvalidAliasNameException;

public class AliasValidator
extends AbstractComponent {
    @Inject
    public AliasValidator(Settings settings) {
        super(settings);
    }

    public void validateAliasAction(AliasAction aliasAction, MetaData metaData) {
        this.validateAlias(aliasAction.alias(), aliasAction.index(), aliasAction.indexRouting(), metaData);
    }

    public void validateAlias(Alias alias, String index, MetaData metaData) {
        this.validateAlias(alias.name(), index, alias.indexRouting(), metaData);
    }

    public void validateAliasMetaData(AliasMetaData aliasMetaData, String index, MetaData metaData) {
        this.validateAlias(aliasMetaData.alias(), index, aliasMetaData.indexRouting(), metaData);
    }

    public void validateAliasStandalone(Alias alias) {
        this.validateAliasStandalone(alias.name(), alias.indexRouting());
        if (Strings.hasLength(alias.filter())) {
            try {
                XContentParser parser = XContentFactory.xContent(alias.filter()).createParser(alias.filter());
                parser.mapAndClose();
            }
            catch (Throwable e) {
                throw new ElasticsearchIllegalArgumentException("failed to parse filter for alias [" + alias.name() + "]", e);
            }
        }
    }

    private void validateAlias(String alias, String index, String indexRouting, MetaData metaData) {
        this.validateAliasStandalone(alias, indexRouting);
        if (!Strings.hasText(index)) {
            throw new ElasticsearchIllegalArgumentException("index name is required");
        }
        assert (metaData != null);
        if (metaData.hasIndex(alias)) {
            throw new InvalidAliasNameException(new Index(index), alias, "an index exists with the same name as the alias");
        }
    }

    private void validateAliasStandalone(String alias, String indexRouting) {
        if (!Strings.hasText(alias)) {
            throw new ElasticsearchIllegalArgumentException("alias name is required");
        }
        if (indexRouting != null && indexRouting.indexOf(44) != -1) {
            throw new ElasticsearchIllegalArgumentException("alias [" + alias + "] has several index routing values associated with it");
        }
    }

    public void validateAliasFilter(String alias, String filter, IndexQueryParserService indexQueryParserService) {
        assert (indexQueryParserService != null);
        try {
            XContentParser parser = XContentFactory.xContent(filter).createParser(filter);
            this.validateAliasFilter(parser, indexQueryParserService);
        }
        catch (Throwable e) {
            throw new ElasticsearchIllegalArgumentException("failed to parse filter for alias [" + alias + "]", e);
        }
    }

    public void validateAliasFilter(String alias, byte[] filter, IndexQueryParserService indexQueryParserService) {
        assert (indexQueryParserService != null);
        try {
            XContentParser parser = XContentFactory.xContent(filter).createParser(filter);
            this.validateAliasFilter(parser, indexQueryParserService);
        }
        catch (Throwable e) {
            throw new ElasticsearchIllegalArgumentException("failed to parse filter for alias [" + alias + "]", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateAliasFilter(XContentParser parser, IndexQueryParserService indexQueryParserService) throws IOException {
        QueryParseContext context = indexQueryParserService.getParseContext();
        try {
            context.reset(parser);
            context.setAllowUnmappedFields(false);
            context.parseInnerFilter();
        }
        finally {
            context.reset(null);
            parser.close();
        }
    }
}

