/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.index.deletionpolicy.SnapshotIndexCommit;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.recovery.RecoverySourceHandler;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.indices.recovery.StartRecoveryRequest;
import org.elasticsearch.transport.TransportService;

public class SharedFSRecoverySourceHandler
extends RecoverySourceHandler {
    private final IndexShard shard;
    private final StartRecoveryRequest request;

    public SharedFSRecoverySourceHandler(IndexShard shard, StartRecoveryRequest request, RecoverySettings recoverySettings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, MappingUpdatedAction mappingUpdatedAction, ESLogger logger) {
        super(shard, request, recoverySettings, transportService, clusterService, indicesService, mappingUpdatedAction, logger);
        this.shard = shard;
        this.request = request;
    }

    @Override
    public void phase1(SnapshotIndexCommit snapshot) throws ElasticsearchException {
        if (this.request.recoveryType() == RecoveryState.Type.RELOCATION && this.shard.routingEntry().primary()) {
            ElasticsearchIllegalStateException exception = new ElasticsearchIllegalStateException("Can't relocate primary - failing");
            this.shard.failShard("primary_relocation", exception);
            throw exception;
        }
        this.logger.trace("{} recovery [phase2] to {}: skipping phase 1 for shared filesystem", this.request.shardId(), this.request.targetNode());
    }

    @Override
    protected int sendSnapshot(Translog.Snapshot snapshot) throws ElasticsearchException {
        this.logger.trace("{} recovery [phase3] to {}: skipping transaction log operations for file sync", this.shard.shardId(), this.request.targetNode());
        return 0;
    }
}

