/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.stats;

import java.io.IOException;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.stats.Stats;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;
import org.elasticsearch.search.aggregations.support.format.ValueFormatterStreams;

public class InternalStats
extends InternalNumericMetricsAggregation.MultiValue
implements Stats {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("stats");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalStats readResult(StreamInput in) throws IOException {
            InternalStats result = new InternalStats();
            result.readFrom(in);
            return result;
        }
    };
    protected long count;
    protected double min;
    protected double max;
    protected double sum;

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    protected InternalStats() {
    }

    public InternalStats(String name, long count, double sum, double min, double max, @Nullable ValueFormatter formatter) {
        super(name);
        this.count = count;
        this.sum = sum;
        this.min = min;
        this.max = max;
        this.valueFormatter = formatter;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public double getMin() {
        return this.min;
    }

    @Override
    public double getMax() {
        return this.max;
    }

    @Override
    public double getAvg() {
        return this.sum / (double)this.count;
    }

    @Override
    public double getSum() {
        return this.sum;
    }

    @Override
    public String getCountAsString() {
        return this.valueAsString(Metrics.count.name());
    }

    @Override
    public String getMinAsString() {
        return this.valueAsString(Metrics.min.name());
    }

    @Override
    public String getMaxAsString() {
        return this.valueAsString(Metrics.max.name());
    }

    @Override
    public String getAvgAsString() {
        return this.valueAsString(Metrics.avg.name());
    }

    @Override
    public String getSumAsString() {
        return this.valueAsString(Metrics.sum.name());
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public double value(String name) {
        Metrics metrics = Metrics.valueOf(name);
        switch (metrics) {
            case min: {
                return this.min;
            }
            case max: {
                return this.max;
            }
            case avg: {
                return this.getAvg();
            }
            case count: {
                return this.count;
            }
            case sum: {
                return this.sum;
            }
        }
        throw new IllegalArgumentException("Unknown value [" + name + "] in common stats aggregation");
    }

    @Override
    public InternalStats reduce(InternalAggregation.ReduceContext reduceContext) {
        long count = 0L;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        double sum = 0.0;
        for (InternalAggregation aggregation : reduceContext.aggregations()) {
            InternalStats stats = (InternalStats)aggregation;
            count += stats.getCount();
            min = Math.min(min, stats.getMin());
            max = Math.max(max, stats.getMax());
            sum += stats.getSum();
        }
        return new InternalStats(this.name, count, sum, min, max, this.valueFormatter);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.valueFormatter = ValueFormatterStreams.readOptional(in);
        this.count = in.readVLong();
        this.min = in.readDouble();
        this.max = in.readDouble();
        this.sum = in.readDouble();
        this.readOtherStatsFrom(in);
    }

    public void readOtherStatsFrom(StreamInput in) throws IOException {
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        ValueFormatterStreams.writeOptional(this.valueFormatter, out);
        out.writeVLong(this.count);
        out.writeDouble(this.min);
        out.writeDouble(this.max);
        out.writeDouble(this.sum);
        this.writeOtherStatsTo(out);
    }

    protected void writeOtherStatsTo(StreamOutput out) throws IOException {
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Fields.COUNT, this.count);
        builder.field(Fields.MIN, this.count != 0L ? Double.valueOf(this.min) : null);
        builder.field(Fields.MAX, this.count != 0L ? Double.valueOf(this.max) : null);
        builder.field(Fields.AVG, this.count != 0L ? Double.valueOf(this.getAvg()) : null);
        builder.field(Fields.SUM, this.count != 0L ? Double.valueOf(this.sum) : null);
        if (this.count != 0L && this.valueFormatter != null) {
            builder.field(Fields.MIN_AS_STRING, this.valueFormatter.format(this.min));
            builder.field(Fields.MAX_AS_STRING, this.valueFormatter.format(this.max));
            builder.field(Fields.AVG_AS_STRING, this.valueFormatter.format(this.getAvg()));
            builder.field(Fields.SUM_AS_STRING, this.valueFormatter.format(this.sum));
        }
        this.otherStatsToXCotent(builder, params);
        return builder;
    }

    protected XContentBuilder otherStatsToXCotent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }

    static class Fields {
        public static final XContentBuilderString COUNT = new XContentBuilderString("count");
        public static final XContentBuilderString MIN = new XContentBuilderString("min");
        public static final XContentBuilderString MIN_AS_STRING = new XContentBuilderString("min_as_string");
        public static final XContentBuilderString MAX = new XContentBuilderString("max");
        public static final XContentBuilderString MAX_AS_STRING = new XContentBuilderString("max_as_string");
        public static final XContentBuilderString AVG = new XContentBuilderString("avg");
        public static final XContentBuilderString AVG_AS_STRING = new XContentBuilderString("avg_as_string");
        public static final XContentBuilderString SUM = new XContentBuilderString("sum");
        public static final XContentBuilderString SUM_AS_STRING = new XContentBuilderString("sum_as_string");

        Fields() {
        }
    }

    static enum Metrics {
        count,
        sum,
        min,
        max,
        avg;


        public static Metrics resolve(String name) {
            return Metrics.valueOf(name);
        }
    }
}

