/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.permissions;

import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import org.knopflerfish.framework.BundleURLStreamHandler;
import org.knopflerfish.framework.permissions.PermissionsHandle;

class FrameworkPolicy
extends Policy {
    private final Policy defaultPolicy;
    private final PermissionsHandle ph;

    FrameworkPolicy(Policy policy, PermissionsHandle ph) {
        this.defaultPolicy = policy;
        this.ph = ph;
    }

    public PermissionCollection getPermissions(ProtectionDomain pd) {
        if (null == pd) {
            return this.defaultPolicy.getPermissions(pd);
        }
        CodeSource cs = pd.getCodeSource();
        if (null == cs) {
            return this.defaultPolicy.getPermissions(pd);
        }
        URL u = cs.getLocation();
        if (u != null && "bundle".equals(u.getProtocol())) {
            return this.getPermissions(cs);
        }
        return this.defaultPolicy.getPermissions(pd);
    }

    public PermissionCollection getPermissions(CodeSource cs) {
        if (null == cs) {
            return this.defaultPolicy.getPermissions(cs);
        }
        URL u = cs.getLocation();
        if (u != null && "bundle".equals(u.getProtocol())) {
            try {
                Long id = new Long(BundleURLStreamHandler.getId(u.getHost()));
                PermissionCollection pc = this.ph.getPermissionCollection(id);
                if (pc != null) {
                    return FrameworkPolicy.copy(pc);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return new Permissions();
        }
        return this.defaultPolicy.getPermissions(cs);
    }

    private static PermissionCollection copy(PermissionCollection pc) {
        Permissions pc2 = new Permissions();
        Enumeration<Permission> e = pc.elements();
        while (e.hasMoreElements()) {
            pc2.add(e.nextElement());
        }
        return pc2;
    }

    public boolean implies(final ProtectionDomain pd, final Permission p) {
        URL u;
        CodeSource cs = null != pd ? pd.getCodeSource() : null;
        URL uRL = u = null != cs ? cs.getLocation() : null;
        if (u != null && "bundle".equals(u.getProtocol())) {
            PermissionCollection pc = this.getPermissions(cs);
            return pc == null ? false : pc.implies(p);
        }
        Boolean res = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return new Boolean(FrameworkPolicy.this.defaultPolicy.implies(pd, p));
            }

            @Override
            public /* synthetic */ Object run() {
                return this.run();
            }
        });
        return res;
    }

    public void refresh() {
        this.defaultPolicy.refresh();
    }
}

