/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.api.internal;

import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.license.License;
import com.xebialabs.license.LicensePeriodExpiredException;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.xltest.api.v1.InfoController;
import com.xebialabs.xltest.domain.LicenseInfo;
import com.xebialabs.xltest.domain.RegistrationInfo;
import com.xebialabs.xltest.service.licenseinstallservice.LicenseInstallService;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/api/internal/license")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@NoCache
public class LicenseController {
    private static final Logger LOG = LoggerFactory.getLogger(InfoController.class);
    private static final String BOOTSTRAP_LICENSE_LICENSEE = "Installation Bootstrap License";
    public static final String XL_TESTVIEW_PRODUCT_NAME = "xl-testview";
    private final LicenseInstallService licenseInstallService;
    private final LicenseService licenseService;
    private final RepositoryService repositoryService;

    @Autowired
    public LicenseController(LicenseInstallService licenseInstallService, LicenseService licenseService, RepositoryService repositoryService) {
        this.licenseInstallService = licenseInstallService;
        this.licenseService = licenseService;
        this.repositoryService = repositoryService;
    }

    @GET
    public LicenseInfo getLicenseInfo() {
        LicenseInfo licenseInfo = new LicenseInfo();
        try {
            this.licenseService.validate();
            License license = this.licenseService.getLicense();
            if (license.getStringValue(LicenseProperty.LICENSED_TO).equals(BOOTSTRAP_LICENSE_LICENSEE)) {
                licenseInfo.setLicense("BOOTSTRAP");
            } else {
                licenseInfo.setLicense("OK");
            }
            licenseInfo.setLicensedTo(license.getStringValue(LicenseProperty.LICENSED_TO));
        }
        catch (LicensePeriodExpiredException e) {
            LOG.debug("License is expired", (Throwable)e);
            licenseInfo.setLicense("EXPIRED");
        }
        catch (Exception e) {
            LOG.debug("Could not validate license", (Throwable)e);
            licenseInfo.setLicense("OTHER_INVALID");
        }
        return licenseInfo;
    }

    @GET
    @Path(value="reload")
    public Response reload() {
        try {
            LOG.info("Reloading license");
            this.licenseService.reload();
            LOG.info("License reloaded");
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception e) {
            LOG.error("License reload failed", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    public Response requestAndInstallLicense(Map<String, Object> registrationForm) throws Exception {
        RegistrationInfo registrationInfo;
        LOG.debug("requestAndInstallLicense: received post: {}", registrationForm);
        try {
            this.licenseInstallService.verifyCanInstallNewLicense();
        }
        catch (Exception e) {
            LOG.debug("Exception during verifying license.", (Throwable)e);
            return Response.status((int)500).build();
        }
        try {
            registrationInfo = RegistrationInfo.fromRegistrationForm(registrationForm);
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            LOG.debug("Validation error on registration form. ", (Throwable)ex);
            return Response.status((int)400).build();
        }
        this.licenseInstallService.downloadAndInstallLicense(XL_TESTVIEW_PRODUCT_NAME, registrationInfo);
        return Response.ok().build();
    }
}

