/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;

public class RegistrationInfo {
    private static final Pattern emailPattern = Pattern.compile(".*@.*\\..*");
    private String firstName = "";
    private String lastName = "";
    private String email = "";
    private String country = "";
    private String state = "";
    private String company = "";
    private String phone = "";
    private static final Map<String, Set<String>> COUNTRY_STATES = Maps.newHashMap();

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName.trim();
        Preconditions.checkArgument((this.firstName.length() > 0 ? 1 : 0) != 0);
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName.trim();
        Preconditions.checkArgument((this.lastName.length() > 0 ? 1 : 0) != 0);
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        Preconditions.checkArgument((boolean)emailPattern.matcher(email).matches());
        this.email = email;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountryState(String country, String state) {
        Preconditions.checkArgument((boolean)COUNTRY_STATES.containsKey(country.toLowerCase()));
        Preconditions.checkArgument((boolean)COUNTRY_STATES.get(country.toLowerCase()).contains(state.toLowerCase()));
        this.country = country;
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company.trim();
    }

    public String getName() {
        return this.firstName + " " + this.lastName;
    }

    public boolean isValid() {
        return this.firstName != null && this.lastName != null && this.country != null && this.company != null && this.email != null;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("firstName", (Object)this.firstName).add("lastName", (Object)this.lastName).add("email", (Object)this.email).add("country", (Object)this.country).add("state", (Object)this.state).add("company", (Object)this.company).toString();
    }

    public static RegistrationInfo fromRegistrationForm(Map<String, Object> registrationForm) {
        RegistrationInfo registrationInfo = new RegistrationInfo();
        registrationInfo.setFirstName(RegistrationInfo.getRequiredValueFromMap(registrationForm, "firstname"));
        registrationInfo.setLastName(RegistrationInfo.getRequiredValueFromMap(registrationForm, "lastname"));
        registrationInfo.setEmail(RegistrationInfo.getRequiredValueFromMap(registrationForm, "email"));
        registrationInfo.setCompany(RegistrationInfo.getRequiredValueFromMap(registrationForm, "company"));
        registrationInfo.setCountryState(RegistrationInfo.getOptionalValueFromMap(registrationForm, "country"), RegistrationInfo.getOptionalValueFromMap(registrationForm, "state"));
        registrationInfo.setPhone(RegistrationInfo.getOptionalValueFromMap(registrationForm, "phone"));
        return registrationInfo;
    }

    private static String getOptionalValueFromMap(Map<String, Object> map, String key) {
        Object value = map.get(key);
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    private static String getRequiredValueFromMap(Map<String, Object> map, String key) {
        Object value = map.get(key);
        if (value == null) {
            throw new IllegalArgumentException("No value set for " + key);
        }
        return value.toString();
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public JsonObject toJsonObject() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("company", this.company);
        builder.add("country", this.country);
        builder.add("email", this.email);
        builder.add("firstName", this.firstName);
        builder.add("lastName", this.lastName);
        builder.add("phone", this.phone);
        builder.add("state", this.state);
        return builder.build();
    }

    static {
        try {
            List lines = Resources.readLines((URL)RegistrationInfo.class.getResource("country-state.properties"), (Charset)StandardCharsets.UTF_8);
            for (String countryLine : lines) {
                List splitList = Splitter.on((char)'=').trimResults().splitToList((CharSequence)countryLine);
                String country = (String)splitList.get(0);
                Iterable regions = Splitter.on((char)'|').trimResults().omitEmptyStrings().split((CharSequence)splitList.get(1));
                COUNTRY_STATES.put(country, Sets.newHashSet((Iterable)regions));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Resource files incorrect", e);
        }
    }
}

