/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.repository;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.xltest.Synthetic;
import com.xebialabs.xltest.domain.ActiveTestSpecification;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.domain.Project;
import com.xebialabs.xltest.repository.TestSpecificationRepository;
import com.xebialabs.xltest.repository.XltNotFoundException;
import com.xebialabs.xltest.utils.JcrUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ProjectRepository {
    private static final Logger LOG = LoggerFactory.getLogger((String)ProjectRepository.class.getName());
    private final RepositoryService repository;
    private final TestSpecificationRepository testSpecificationRepository;

    @Autowired
    public ProjectRepository(RepositoryService repository, TestSpecificationRepository testSpecificationRepository) {
        this.repository = repository;
        this.testSpecificationRepository = testSpecificationRepository;
    }

    public List<Project> getProjects() {
        SearchParameters query = new SearchParameters();
        query.setType(Type.valueOf((String)Synthetic.PROJECT.name));
        return this.repository.listEntities(query);
    }

    public Project getProject(String projectId) {
        return (Project)this.repository.read(Synthetic.createProjectId(projectId));
    }

    public Project createProject(Project project) {
        try {
            project.setId(Synthetic.createNewProjectId());
            this.checkTitleUnique(project);
            this.repository.create((ConfigurationItem[])new Project[]{project});
            Project project2 = project;
            return project2;
        }
        catch (Exception e) {
            LOG.error("Error creating project {}. Exception: {}", (Object)project, (Object)e);
            throw e;
        }
        finally {
            LOG.info("Finished creating project {}", (Object)project);
        }
    }

    public void delete(String projectId) {
        for (BaseTestSpecification testSpecification : this.getTestSpecifications(projectId)) {
            this.testSpecificationRepository.deleteTestSpecification(projectId, testSpecification.getName());
        }
        this.repository.delete(new String[]{Synthetic.createProjectId(projectId)});
    }

    public List<BaseTestSpecification> getTestSpecifications(String projectName) {
        SearchParameters query = new SearchParameters();
        query.setType(Type.valueOf(BaseTestSpecification.class));
        query.setParent(Synthetic.createProjectId(projectName));
        return this.repository.listEntities(query);
    }

    public BaseTestSpecification createSpecificationForProject(String projectId, BaseTestSpecification item) {
        try {
            ConfigurationItem[] entities;
            this.testSpecificationRepository.validate(item);
            item.setId(Synthetic.createNewSpecificationForProjectId(projectId));
            this.setOsIfLocalhost(item);
            ArrayList<ConfigurationItem> toBeCreatedItems = new ArrayList<ConfigurationItem>();
            toBeCreatedItems.add((ConfigurationItem)item);
            this.searchForNestedToBeCreatedCis((ConfigurationItem)item, toBeCreatedItems);
            for (ConfigurationItem entity : entities = toBeCreatedItems.toArray(new ConfigurationItem[toBeCreatedItems.size()])) {
                JcrUtils.validateJcrId(entity);
                this.repository.create(new ConfigurationItem[]{entity});
            }
            BaseTestSpecification baseTestSpecification = item;
            return baseTestSpecification;
        }
        catch (Exception e) {
            LOG.error("Error creating testSpecification {} for project {}. Exception: {}", new Object[]{item, projectId, e});
            throw e;
        }
        finally {
            LOG.info("Finished creating testSpecification {}", (Object)item);
        }
    }

    public void validateValidParentProject(BaseTestSpecification baseTestSpecification) {
        String projectId = baseTestSpecification.getProjectId();
        if (!this.repository.exists(projectId)) {
            throw new XltNotFoundException(projectId);
        }
    }

    private void setOsIfLocalhost(BaseTestSpecification item) {
        ActiveTestSpecification testSpecification;
        Host host;
        if (item instanceof ActiveTestSpecification && (host = (testSpecification = (ActiveTestSpecification)item).getHost()).getType().instanceOf(Type.valueOf((String)"overthere.LocalHost"))) {
            host.setOs(OperatingSystemFamily.getLocalHostOperatingSystemFamily());
        }
    }

    public void update(Project project) {
        this.checkTitleUnique(project);
        this.repository.update((ConfigurationItem[])new Project[]{project});
    }

    public Result updateSpecification(String currentProjectId, String specificationName, BaseTestSpecification testSpecification) {
        this.testSpecificationRepository.validate(testSpecification);
        String expectedId = Synthetic.createSpecificationForProjectId(currentProjectId, specificationName);
        if (!expectedId.equals(testSpecification.getId())) {
            this.validateValidParentProject(testSpecification);
            this.repository.move(expectedId, testSpecification.getId());
            return Result.MOVED;
        }
        this.repository.createOrUpdate((ConfigurationItem[])new BaseTestSpecification[]{testSpecification});
        return Result.UPDATED;
    }

    private void searchForNestedToBeCreatedCis(ConfigurationItem item, List<ConfigurationItem> toBeCreatedCis) {
        for (PropertyDescriptor property : item.getType().getDescriptor().getPropertyDescriptors()) {
            ConfigurationItem child;
            if (property.getKind() != PropertyKind.CI || (child = (ConfigurationItem)item.getProperty(property.getName())) == null || this.repository.exists(child.getId())) continue;
            toBeCreatedCis.add(0, child);
            this.searchForNestedToBeCreatedCis(child, toBeCreatedCis);
        }
    }

    private void checkTitleUnique(Project project) {
        SearchParameters query = new SearchParameters();
        query.setType(Type.valueOf((String)Synthetic.PROJECT.name));
        query.addProperty("title", project.getTitle());
        List configurationItems = this.repository.listEntities(query);
        if (!configurationItems.isEmpty()) {
            throw new ItemAlreadyExistsException("Field [%s] must be unique. An object with value [%s] already exists", new Object[]{"title", project.getTitle()});
        }
    }

    public void moveAllTestSpecifications(String projectId, String moveToProject) {
        List<BaseTestSpecification> testSpecifications = this.getTestSpecifications(projectId);
        for (BaseTestSpecification testSpecification : testSpecifications) {
            String newId = Synthetic.createSpecificationForProjectId(moveToProject, testSpecification.getName());
            this.repository.move(testSpecification.getId(), newId);
        }
    }

    public static enum Result {
        MOVED,
        UPDATED;

    }
}

