/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.repository;

import com.google.common.io.CharStreams;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xltest.repository.ScriptExecutionException;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlContext;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.PropertyPermission;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.python.core.codecs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(ScriptExecutor.class);
    public static final String ENGINE = "python";
    public static final String SCRIPT_EXTENSION = ".py";
    public static final String SCRIPT_LOCATION_PROPERTY = "scriptLocation";
    private ScriptEngine scriptEngine = this.initScriptEngine();
    private AccessControlContext accessControlContext;

    public ScriptExecutor(PermissionCollection permissions) {
        this.accessControlContext = this.initAccessControlContext(permissions);
    }

    public void evalScript(String script, ScriptContext scriptContext) throws ScriptExecutionException {
        try {
            this.scriptEngine.eval(script, scriptContext);
        }
        catch (ScriptException e) {
            throw new ScriptExecutionException("Unable to evaluate script <<<" + script + ">>>", e);
        }
    }

    private ScriptEngine initScriptEngine() {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName(ENGINE);
        codecs.setDefaultEncoding((String)Charset.defaultCharset().name());
        return engine;
    }

    private AccessControlContext initAccessControlContext(PermissionCollection permissions) {
        ProtectionDomain domain = new ProtectionDomain(new CodeSource(null, (Certificate[])null), this.extendsMinimalPermissionsWith(permissions));
        return new AccessControlContext(new ProtectionDomain[]{domain});
    }

    private Permissions extendsMinimalPermissionsWith(PermissionCollection permissions) {
        Permissions minimalPermissions = new Permissions();
        minimalPermissions.add(new PropertyPermission("user.dir", "read"));
        minimalPermissions.add(new RuntimePermission("createClassLoader"));
        minimalPermissions.add(new RuntimePermission("getProtectionDomain"));
        this.addJythonLibrariesReadPermission(minimalPermissions);
        if (permissions != null) {
            Enumeration<Permission> permissionEnumeration = permissions.elements();
            while (permissionEnumeration.hasMoreElements()) {
                minimalPermissions.add(permissionEnumeration.nextElement());
            }
        }
        return minimalPermissions;
    }

    private void addJythonLibrariesReadPermission(Permissions minimalPermissions) {
        this.addReadPermissionOnJar("jython-standalone", minimalPermissions);
        minimalPermissions.add(new PropertyPermission("os.name", "read"));
        minimalPermissions.add(new PropertyPermission("os.arch", "read"));
    }

    private void addReadPermissionOnJar(String jarName, Permissions minimalPermissions) {
        String classPath = System.getProperty("java.class.path");
        String classPathSeparator = System.getProperty("path.separator");
        Pattern pattern = Pattern.compile("([^" + classPathSeparator + "]*" + jarName + "[^" + classPathSeparator + "]*)");
        Matcher matcher = pattern.matcher(classPath);
        while (matcher.find()) {
            String group = matcher.group();
            minimalPermissions.add(new FilePermission(group, "read"));
            LOG.debug("Minimal permission added on: {}", (Object)group);
        }
    }

    public void evalScriptedCi(ConfigurationItem ci, ScriptContext scriptContext) throws ScriptExecutionException, FileNotFoundException {
        this.evalScriptedCi(ci, SCRIPT_LOCATION_PROPERTY, scriptContext);
    }

    public void evalScriptedCi(ConfigurationItem ci, String scriptLocationPropertyName, ScriptContext scriptContext) throws ScriptExecutionException, FileNotFoundException {
        String scriptLocation = (String)ci.getProperty(scriptLocationPropertyName);
        if (scriptLocation == null || scriptLocation.equals("")) {
            String defaultPath = this.getDefaultPath(ci);
            LOG.info("falling back to default location: " + defaultPath);
            this.evalScriptFile(defaultPath, scriptContext);
        } else {
            try {
                this.evalScriptFile(scriptLocation, scriptContext);
            }
            catch (FileNotFoundException e) {
                throw new ScriptExecutionException("Can not execute script: " + e.getMessage(), e);
            }
        }
    }

    private String getDefaultPath(ConfigurationItem ci) {
        Type type = ci.getType();
        String prefix = type.getPrefix();
        String name = type.getName();
        return prefix + "/" + name + SCRIPT_EXTENSION;
    }

    private String readScript(String path) throws ScriptExecutionException, FileNotFoundException {
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        if (null == stream) {
            throw new FileNotFoundException("Unable to find script '" + path + "' in class path.");
        }
        try {
            String string = CharStreams.toString((Readable)new InputStreamReader(stream, StandardCharsets.UTF_8));
            return string;
        }
        catch (IOException e) {
            throw new ScriptExecutionException("Unable to read script file '" + path + "'", e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOG.warn("Exception while closing stream for script '{}'", (Object)path, (Object)e);
            }
        }
    }

    public void evalScriptFile(String path, ScriptContext scriptContext) throws ScriptExecutionException, FileNotFoundException {
        LOG.debug("Will execute script {} in context {}", (Object)path, (Object)scriptContext);
        String script = this.readScript(path);
        try {
            this.evalScript(script, scriptContext);
        }
        catch (Throwable t) {
            throw new ScriptExecutionException("Failed to evaluate script '" + path + "'", t);
        }
        LOG.debug("Script {} executed successfully.", (Object)path);
    }
}

