/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.repository;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.xltest.Synthetic;
import com.xebialabs.xltest.domain.ActiveTestSpecification;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.domain.DashboardTile;
import com.xebialabs.xltest.domain.Report;
import com.xebialabs.xltest.domain.TestSpecificationSet;
import com.xebialabs.xltest.domain.TestTool;
import com.xebialabs.xltest.domain.TestToolNameAware;
import com.xebialabs.xltest.repository.DashboardRepository;
import com.xebialabs.xltest.repository.HostRepository;
import com.xebialabs.xltest.repository.TestToolRepository;
import com.xebialabs.xltest.service.EventRepository;
import com.xebialabs.xltest.utils.TestToolUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.TermFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TestSpecificationRepository {
    private static final Logger LOG = LoggerFactory.getLogger(TestSpecificationRepository.class);
    private final DashboardRepository dashboardRepository;
    private final RepositoryService repository;
    private final HostRepository hosts;
    private final TestToolRepository testToolRepository;
    private final EventRepository eventRepository;

    @Autowired
    public TestSpecificationRepository(RepositoryService repositoryService, DashboardRepository dashboardRepository, HostRepository hosts, TestToolRepository testToolRepository, EventRepository eventRepository) {
        this.repository = repositoryService;
        this.dashboardRepository = dashboardRepository;
        this.hosts = hosts;
        this.testToolRepository = testToolRepository;
        this.eventRepository = (EventRepository)Preconditions.checkNotNull((Object)eventRepository);
    }

    public BaseTestSpecification getSpecificationForProject(String projectName, String testSpecificationName) {
        return (BaseTestSpecification)this.repository.read(Synthetic.createSpecificationForProjectId(projectName, testSpecificationName));
    }

    public List<BaseTestSpecification> getAll() {
        SearchParameters searchParams = new SearchParameters();
        searchParams.setType(Type.valueOf(BaseTestSpecification.class));
        return this.repository.listEntities(searchParams);
    }

    public List<TestSpecificationSet> getAllSets() {
        SearchParameters searchParams = new SearchParameters();
        searchParams.setType(Type.valueOf(TestSpecificationSet.class));
        return this.repository.listEntities(searchParams);
    }

    @Deprecated
    public BaseTestSpecification getById(String testSpecificationId) {
        SearchParameters searchParams = new SearchParameters();
        searchParams.setName(testSpecificationId);
        searchParams.setType(Type.valueOf(BaseTestSpecification.class));
        return this.listOneResult(searchParams, testSpecificationId);
    }

    public BaseTestSpecification getById(UUID testSpecificationId) {
        return this.getById(testSpecificationId.toString());
    }

    public BaseTestSpecification get(String testSpecificationName) {
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.setName(testSpecificationName);
        searchParameters.setType(Type.valueOf(BaseTestSpecification.class));
        searchParameters.setDepth(2);
        return this.listOneResult(searchParameters, testSpecificationName);
    }

    @Deprecated
    private List<ActiveTestSpecification> findBy(String testToolName, String searchPattern, String workingDirectory) {
        SearchParameters criteria = new SearchParameters().setType(Type.valueOf(ActiveTestSpecification.class));
        criteria.addProperty("testToolName", testToolName);
        criteria.addProperty("searchPattern", searchPattern);
        criteria.addProperty("workingDirectory", workingDirectory);
        List result = this.repository.listEntities(criteria);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    @Deprecated
    public List<ActiveTestSpecification> findWithHost(String testToolName, String searchPattern, String address, String workingDirectory, int port, String hostType) {
        Host host;
        List<ActiveTestSpecification> testSpecifications = this.findBy(testToolName, searchPattern, workingDirectory);
        ArrayList<ActiveTestSpecification> results = new ArrayList<ActiveTestSpecification>();
        if (testSpecifications.size() > 0 && (host = this.hosts.findHost(address == null ? "" : address, port, hostType)) != null) {
            for (ActiveTestSpecification ts : testSpecifications) {
                if (!ts.getHost().getId().equals(host.getId())) continue;
                results.add(ts);
            }
        }
        return results;
    }

    public List<Descriptor> findReportsForTestSpecification(String testSpecificationId) {
        BaseTestSpecification testSpecification = this.getById(testSpecificationId);
        TestTool testTool = TestToolUtils.getTestTool(this.testToolRepository, testSpecification);
        return TestSpecificationRepository.findReportsForTestTool(testTool);
    }

    public List<Descriptor> findReportsForTestSpecification(BaseTestSpecification testSpecification) {
        TestTool testTool = TestToolUtils.getTestTool(this.testToolRepository, testSpecification);
        return TestSpecificationRepository.findReportsForTestTool(testTool);
    }

    private static List<Descriptor> findReportsForTestTool(TestTool testTool) {
        ArrayList<Descriptor> result = new ArrayList<Descriptor>();
        Collection children = DescriptorRegistry.getSubtypes((Type)Type.valueOf(Report.class));
        for (Type child : children) {
            Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)child);
            Set reportCategories = (Set)descriptor.getPropertyDescriptor("applicableCategories").getDefaultValue();
            if (descriptor.isVirtual() || !reportCategories.contains(testTool.getCategory()) || !((Boolean)descriptor.getPropertyDescriptor("visibleOnTestSpecificationLevel").getDefaultValue()).booleanValue()) continue;
            result.add(descriptor);
        }
        return result;
    }

    public void deleteTestSpecification(String projectName, String testSpecificationName) {
        LOG.info("removing test specification:" + testSpecificationName);
        this.dashboardRepository.deleteDashboardTilesBySpecificationName(testSpecificationName);
        BaseTestSpecification testSpecification = this.getSpecificationForProject(projectName, testSpecificationName);
        this.removeIncludingReferences(testSpecification, this.getAll());
        LOG.info("removed test specification:" + testSpecificationName);
    }

    public void deleteTestSpecificationReferenceFromParent(String projectName, String testSpecificationNameToRemove, String testSpecificationNameOfParent) {
        BaseTestSpecification testSpecificationToRemove = this.getSpecificationForProject(projectName, testSpecificationNameToRemove);
        if (testSpecificationToRemove == null) {
            throw new IllegalArgumentException("There is no specification found with name " + testSpecificationNameToRemove);
        }
        TestSpecificationSet testSpecificationParent = (TestSpecificationSet)this.getSpecificationForProject(projectName, testSpecificationNameOfParent);
        if (testSpecificationParent == null) {
            throw new IllegalArgumentException("There is no parent test specificationSet found with name " + testSpecificationNameOfParent);
        }
        ArrayList<BaseTestSpecification> newListOfChildren = new ArrayList<BaseTestSpecification>();
        boolean foundReferenceToRemove = false;
        for (BaseTestSpecification testSpec : testSpecificationParent.getTestSpecifications()) {
            if (testSpec.getId().equals(testSpecificationToRemove.getId())) {
                foundReferenceToRemove = true;
                continue;
            }
            newListOfChildren.add(testSpec);
        }
        if (foundReferenceToRemove) {
            testSpecificationParent.setTestSpecifications(newListOfChildren);
            try {
                this.repository.createOrUpdate((ConfigurationItem[])new TestSpecificationSet[]{testSpecificationParent});
            }
            catch (Exception e) {
                LOG.error("Error removing reference of specification with name {} for specification with parent name {}", (Object)testSpecificationNameToRemove, (Object)testSpecificationNameOfParent);
                throw e;
            }
        } else {
            throw new IllegalArgumentException("Specification " + testSpecificationNameToRemove + " cannot be found, and thus not be removed from parent " + testSpecificationNameOfParent);
        }
    }

    private void removeIncludingReferences(BaseTestSpecification testSpecificationToRemove, List<BaseTestSpecification> allTestSpecifications) {
        for (BaseTestSpecification testSpec : allTestSpecifications) {
            if (!(testSpec instanceof TestSpecificationSet)) continue;
            this.removeTestSpecificationReferenceFromSuperSetsRecursively(testSpecificationToRemove, (TestSpecificationSet)testSpec);
        }
        List<DashboardTile> dashboardTiles = this.dashboardRepository.findDashboardTilesBySpecificationName(testSpecificationToRemove.getName());
        for (DashboardTile dashboardTile : dashboardTiles) {
            this.dashboardRepository.deleteTile(dashboardTile);
        }
        this.repository.delete(new String[]{testSpecificationToRemove.getId()});
        this.deleteAssociatedEvents(testSpecificationToRemove);
    }

    private void deleteAssociatedEvents(BaseTestSpecification testSpecification) {
        LOG.info("About to remove the events from elastic search");
        TermFilterBuilder filterBuilder = FilterBuilders.termFilter((String)"testSpecification", (String)testSpecification.getName());
        this.eventRepository.delete((FilterBuilder)filterBuilder);
    }

    private void removeTestSpecificationReferenceFromSuperSetsRecursively(BaseTestSpecification testSpecification, TestSpecificationSet testSetSpec) {
        ArrayList<BaseTestSpecification> newListOfChildren = new ArrayList<BaseTestSpecification>();
        boolean referencePresent = false;
        for (BaseTestSpecification testSpec : testSetSpec.getTestSpecifications()) {
            if (testSpec.getId().equals(testSpecification.getId())) {
                referencePresent = true;
                continue;
            }
            newListOfChildren.add(testSpec);
            if (!(testSpec instanceof TestSpecificationSet)) continue;
            this.removeTestSpecificationReferenceFromSuperSetsRecursively(testSpecification, (TestSpecificationSet)testSpec);
        }
        if (referencePresent) {
            testSetSpec.setTestSpecifications(newListOfChildren);
            this.repository.createOrUpdate((ConfigurationItem[])new TestSpecificationSet[]{testSetSpec});
        }
    }

    private BaseTestSpecification listOneResult(SearchParameters searchParameters, String testSpecificationName) {
        List results = this.repository.listEntities(searchParameters);
        if (results.isEmpty()) {
            throw new NotFoundException("TestSpecification [%s] not found", new Object[]{testSpecificationName});
        }
        if (results.size() > 1) {
            throw new IllegalStateException(String.format("Expected one TestSpecification but got %d results for [%s]", results.size(), testSpecificationName));
        }
        return (BaseTestSpecification)((Object)results.get(0));
    }

    public List<TestSpecificationSet> findTestSpecificationSetsForSpecification(String testSpecificationName) {
        ArrayList<TestSpecificationSet> found = new ArrayList<TestSpecificationSet>();
        List<TestSpecificationSet> testSpecificationSets = this.getAllSets();
        for (TestSpecificationSet testSpecificationSet : testSpecificationSets) {
            for (BaseTestSpecification testSpecification : testSpecificationSet.getTestSpecifications()) {
                if (!testSpecification.getName().equals(testSpecificationName)) continue;
                found.add(testSpecificationSet);
            }
        }
        return found;
    }

    public void validate(BaseTestSpecification testSpecification) {
        this.checkAndCorrectTestTool(testSpecification);
        this.checkQualification(testSpecification);
    }

    private void checkAndCorrectTestTool(BaseTestSpecification testSpecification) {
        if (!(testSpecification instanceof TestToolNameAware)) {
            return;
        }
        TestToolNameAware testToolTestSpec = (TestToolNameAware)((Object)testSpecification);
        String testTool = testToolTestSpec.getTestToolName();
        Preconditions.checkArgument((!testTool.isEmpty() ? 1 : 0) != 0);
        Collection<TestTool> testTools = this.testToolRepository.getTestTools();
        ArrayList toolNames = new ArrayList();
        for (TestTool tool : testTools) {
            if (!tool.getName().equalsIgnoreCase(testTool)) continue;
            testToolTestSpec.setTestToolName(tool.getName());
            return;
        }
        LOG.debug("Testtool {} is not included in the list of testtools available: {}", (Object)testTool, toolNames);
        ValidationMessage validationMessage = ValidationMessage.error((String)testSpecification.getId(), (String)"testToolName", (String)String.format("TestTool %s is not supported. Please select one from the dropdown menu.", testTool));
        testSpecification.set$validationMessages(Collections.singletonList(validationMessage));
        throw new Validator.ValidationsFailedException((ConfigurationItem)testSpecification);
    }

    private void checkQualification(BaseTestSpecification testSpecification) {
        boolean exists;
        if (!testSpecification.hasQualificationType()) {
            return;
        }
        String qualificationType = testSpecification.getQualificationType();
        try {
            exists = DescriptorRegistry.exists((Type)Type.valueOf((String)qualificationType));
        }
        catch (Exception e) {
            throw new Validator.ValidationsFailedException((ConfigurationItem)testSpecification);
        }
        if (!exists) {
            throw new Validator.ValidationsFailedException((ConfigurationItem)testSpecification);
        }
    }
}

