/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.serialize.metadata;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xltest.serialize.metadata.PropertyDescriptorJsonWriter;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.springframework.stereotype.Component;

@Component
@Provider
@Produces(value={"application/json"})
public class DescriptorJsonWriter
implements MessageBodyWriter<Descriptor> {
    public boolean isWriteable(Class<?> type, java.lang.reflect.Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Descriptor.class.isAssignableFrom(type);
    }

    public long getSize(Descriptor descriptor, Class<?> type, java.lang.reflect.Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Descriptor descriptor, Class<?> type, java.lang.reflect.Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(this.toJson(descriptor).getBytes(StandardCharsets.UTF_8));
    }

    @VisibleForTesting
    String toJson(Descriptor descriptor) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter((Writer)stringWriter);
        this.writeJson(descriptor, writer);
        return stringWriter.toString();
    }

    public void writeJson(Descriptor descriptor, JsonWriter writer) {
        writer.object();
        writer.key("type").value((Object)descriptor.getType().toString());
        writer.key("name").value((Object)descriptor.getType().getName());
        this.writeSuperTypes(writer, descriptor);
        writer.key("virtual").value(descriptor.isVirtual());
        if (!descriptor.isVirtual() && descriptor.getRoot().getRootNodeName() != null) {
            writer.key("root").value((Object)descriptor.getRoot().getRootNodeName());
        }
        writer.key("description").value((Object)descriptor.getDescription());
        writer.key("label").value((Object)descriptor.getLabel());
        DescriptorJsonWriter.writePropertyDescriptors(writer, descriptor);
        writer.endObject();
    }

    private void writeSuperTypes(JsonWriter writer, Descriptor descriptor) {
        writer.key("extends");
        writer.array();
        for (Type superType : descriptor.getSuperClasses()) {
            if ("BaseConfigurationItem".equals(superType.getName())) continue;
            writer.value((Object)superType.toString());
        }
        writer.endArray();
    }

    private static void writePropertyDescriptors(JsonWriter writer, Descriptor descriptor) {
        writer.key("properties");
        writer.array();
        for (PropertyDescriptor pd : descriptor.getPropertyDescriptors()) {
            PropertyDescriptorJsonWriter.writePropertyDescriptor(writer, pd);
        }
        writer.endArray();
    }
}

