/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.utils;

import com.xebialabs.xltest.domain.AlreadyImportedException;
import com.xebialabs.xltest.domain.CannotRewriteHistoryException;
import com.xebialabs.xltest.domain.ExecutionResult;
import com.xebialabs.xltest.domain.NothingToImportException;
import com.xebialabs.xltest.service.ExecutionProgressEvent;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutingTestRun {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutingTestRun.class);
    private final UUID testRunId;
    private final String testSpecificationName;
    private Date startTime;
    private Date finishedTime;
    private String failureReason;
    private boolean qualificationResult;
    private long averagePreviousDuration;
    private Future<String> task;
    private Date lastUpdateTime;

    public ExecutingTestRun(String testSpecificationName, UUID taskId, Future<String> theTask) {
        this.testSpecificationName = testSpecificationName;
        this.testRunId = taskId;
        this.task = theTask;
    }

    public boolean isTestSpecificationSet() {
        return this.task == null;
    }

    public UUID getTestRunId() {
        return this.testRunId;
    }

    public String getTestSpecificationName() {
        return this.testSpecificationName;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getFinishedTime() {
        return this.finishedTime;
    }

    public void setFinishedTime(Date finishedTime) {
        this.finishedTime = finishedTime;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public boolean isQualificationResult() {
        return this.qualificationResult;
    }

    public void setQualificationResult(boolean qualificationResult) {
        this.qualificationResult = qualificationResult;
    }

    public long timeElapsed() {
        return new Date().getTime() - this.getStartTime().getTime();
    }

    public long getAveragePreviousDuration() {
        return this.averagePreviousDuration;
    }

    public void setAveragePreviousDuration(long averagePreviousDuration) {
        this.averagePreviousDuration = averagePreviousDuration;
    }

    public Future<String> getTask() {
        return this.task;
    }

    public void setTask(Future<String> task) {
        this.task = task;
    }

    public ExecutionProgressEvent getProgressEvent(long longestAveragePreviousDuration) {
        ExecutionProgressEvent progressEvent = this.handleExceptions();
        if (progressEvent != null) {
            return progressEvent;
        }
        long timeSpent = System.currentTimeMillis() - this.startTime.getTime();
        long timeLeft = longestAveragePreviousDuration - timeSpent;
        int percentage = longestAveragePreviousDuration == 0L ? 100 : (timeLeft > 0L ? Math.min((int)(timeSpent * 100L / longestAveragePreviousDuration), 100) : 200);
        ExecutionResult executionResult = this.getExecutionResult();
        ExecutionResult.ExecutionStatus status = executionResult.getStatus();
        if (status == ExecutionResult.ExecutionStatus.FAILED || status == ExecutionResult.ExecutionStatus.FINISHED) {
            percentage = 100;
        }
        return new ExecutionProgressEvent(this.testSpecificationName, executionResult, timeLeft, percentage);
    }

    public ExecutionResult getExecutionResult() {
        if (this.startTime != null && this.finishedTime == null) {
            return ExecutionResult.running((long)this.timeElapsed());
        }
        if (this.startTime != null && this.finishedTime != null) {
            return this.qualificationResult ? ExecutionResult.finished() : ExecutionResult.failed((String)this.failureReason);
        }
        return ExecutionResult.notRunning();
    }

    private ExecutionProgressEvent handleExceptions() {
        if (this.getTask().isDone()) {
            try {
                this.getTask().get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof AlreadyImportedException || e.getCause() instanceof NothingToImportException) {
                    return new ExecutionProgressEvent(this.testSpecificationName, ExecutionResult.noData((String)e.getMessage()), 0L, 100);
                }
                if (e.getCause() instanceof CannotRewriteHistoryException) {
                    return new ExecutionProgressEvent(this.testSpecificationName, ExecutionResult.cannotRewriteHistory((String)e.getMessage()), 0L, 100);
                }
                LOG.warn("Unknown error while execution: ", (Throwable)e);
                return new ExecutionProgressEvent(this.testSpecificationName, ExecutionResult.unknownError(), 0L, 100);
            }
        }
        return null;
    }
}

