/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.utils.glob;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xltest.utils.OverthereFileComparator;
import com.xebialabs.xltest.utils.glob.FileMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Globbit {
    private static final Logger LOG = LoggerFactory.getLogger(Globbit.class);

    private Globbit() {
    }

    public static SortedSet<OverthereFile> find(OverthereFile root, FileMatcher matcher, GlobMode mode) {
        List<OverthereFile> allFilesAndDirectories = Globbit.recurseAllFilesAndDirectories(root);
        TreeSet<OverthereFile> matched = new TreeSet<OverthereFile>(new OverthereFileComparator());
        String fileSeparator = root.getConnection().getHostOperatingSystem().getFileSeparator();
        String workingDirectory = root.getPath() + fileSeparator;
        for (OverthereFile file : allFilesAndDirectories) {
            int indexOf;
            String path;
            String relativePath;
            String normalizedPath;
            if (mode == GlobMode.FILES_ONLY && file.isDirectory() || !matcher.match(normalizedPath = (relativePath = (path = file.getPath()).substring(indexOf = path.indexOf(workingDirectory) + workingDirectory.length())).replace("\\", "/"))) continue;
            matched.add(file);
        }
        return matched;
    }

    private static List<OverthereFile> recurseAllFilesAndDirectories(OverthereFile file) {
        List overthereFiles;
        if (!file.isDirectory()) {
            return Collections.singletonList(file);
        }
        ArrayList<OverthereFile> result = new ArrayList<OverthereFile>();
        result.add(file);
        try {
            overthereFiles = file.listFiles();
        }
        catch (NullPointerException npe) {
            return Collections.emptyList();
        }
        for (OverthereFile child : overthereFiles) {
            result.addAll(Globbit.recurseAllFilesAndDirectories(child));
        }
        return result;
    }

    public static enum GlobMode {
        FILES_ONLY,
        FILES_AND_DIRECTORIES;

    }
}

