/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.html.HtmlUtil;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.ErrorResponder;
import fitnesse.responders.NotFoundResponder;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VariableTool;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageProperties;
import fitnesse.wiki.WikiPageProperty;
import fitnesse.wiki.WikiPageUtil;
import fitnesse.wiki.fs.DiskFileSystem;
import fitnesse.wiki.fs.FileSystem;
import fitnesse.wikitext.parser.WikiWordBuilder;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class SymbolicLinkResponder
implements Responder {
    private final FileSystem fileSystem;
    private Response response;
    private String resource;
    private FitNesseContext context;
    private WikiPage page;

    public SymbolicLinkResponder(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public SymbolicLinkResponder() {
        this(new DiskFileSystem());
    }

    @Override
    public Response makeResponse(FitNesseContext context, Request request) throws IOException {
        this.resource = request.getResource();
        this.context = context;
        PageCrawler crawler = context.getRootPage().getPageCrawler();
        this.page = crawler.getPage(PathParser.parse(this.resource));
        if (this.page == null) {
            return new NotFoundResponder().makeResponse(context, request);
        }
        this.response = new SimpleResponse();
        if (request.hasInput("removal")) {
            this.removeSymbolicLink(request, this.page);
        } else if (request.hasInput("rename")) {
            this.renameSymbolicLink(request, this.page);
        } else {
            this.addSymbolicLink(request, this.page);
        }
        return this.response;
    }

    private void setRedirect(String resource) {
        this.response.redirect(this.context.contextRoot, resource + "?properties#symbolics");
    }

    private void removeSymbolicLink(Request request, WikiPage page) {
        String linkToRemove = request.getInput("removal");
        PageData data = page.getData();
        WikiPageProperties properties = data.getProperties();
        WikiPageProperty symLinks = this.getSymLinkProperty(properties);
        symLinks.remove(linkToRemove);
        if (symLinks.keySet().isEmpty()) {
            properties.remove("SymbolicLinks");
        }
        page.commit(data);
        this.setRedirect(this.resource);
    }

    private void renameSymbolicLink(Request request, WikiPage page) {
        PageData data;
        WikiPageProperties properties;
        WikiPageProperty symLinks;
        String linkToRename = request.getInput("rename");
        String newName = request.getInput("newname");
        if (this.isValidWikiPageName(newName, symLinks = this.getSymLinkProperty(properties = (data = page.getData()).getProperties()))) {
            String currentPath = symLinks.get(linkToRename);
            symLinks.remove(linkToRename);
            symLinks.set(newName, currentPath);
            page.commit(data);
            this.setRedirect(this.resource);
        }
    }

    private void addSymbolicLink(Request request, WikiPage page) throws IOException {
        String linkName = StringUtils.trim(request.getInput("linkName"));
        String linkPath = StringUtils.trim(request.getInput("linkPath"));
        PageData data = page.getData();
        WikiPageProperties properties = data.getProperties();
        WikiPageProperty symLinks = this.getSymLinkProperty(properties);
        if (this.isValidLinkPathName(linkPath) && this.isValidWikiPageName(linkName, symLinks)) {
            symLinks.set(linkName, linkPath);
            page.commit(data);
            this.setRedirect(this.resource);
        }
    }

    private boolean isValidWikiPageName(String linkName, WikiPageProperty symLinks) {
        if (this.page.hasChildPage(linkName) && !symLinks.has(linkName)) {
            this.response = new ErrorResponder(this.resource + " already has a child named " + linkName + ".").makeResponse(this.context, null);
            this.response.setStatus(412);
            return false;
        }
        if (!PathParser.isSingleWikiWord(linkName)) {
            this.response = new ErrorResponder(linkName + " is not a valid WikiWord.").makeResponse(this.context, null);
            this.response.setStatus(412);
            return false;
        }
        return true;
    }

    private boolean isValidLinkPathName(String linkPath) throws IOException {
        if (this.isFilePath(linkPath) && !this.isValidDirectoryPath(linkPath)) {
            String message = "Cannot create link to the file system path '" + linkPath + "'." + " The canonical file system path used was ;" + this.createFileFromPath(linkPath).getCanonicalPath() + "'." + " Either it doesn't exist or it's not a directory.";
            this.response = new ErrorResponder(message).makeResponse(this.context, null);
            this.response.setStatus(404);
            return false;
        }
        if (!this.isFilePath(linkPath) && this.isInternalPageThatDoesntExist(linkPath)) {
            this.response = new ErrorResponder("The page to which you are attempting to link, " + HtmlUtil.escapeHTML(linkPath) + ", doesn't exist.").makeResponse(this.context, null);
            this.response.setStatus(404);
            return false;
        }
        return true;
    }

    private boolean isValidDirectoryPath(String linkPath) {
        File file = this.createFileFromPath(linkPath);
        if (this.fileSystem.exists(file)) {
            return this.fileSystem.isDirectory(file);
        }
        File parentDir = file.getParentFile();
        return parentDir != null && this.fileSystem.exists(parentDir) && this.fileSystem.isDirectory(parentDir);
    }

    private File createFileFromPath(String linkPath) {
        String fullPageURI = new VariableTool(this.context.variableSource).replace(linkPath);
        return WikiPageUtil.resolveFileUri(fullPageURI, new File(this.context.rootPath));
    }

    private boolean isFilePath(String linkPath) {
        return linkPath.startsWith("file:");
    }

    private boolean isInternalPageThatDoesntExist(String linkPath) {
        String expandedPath = WikiWordBuilder.expandPrefix(this.page, linkPath);
        WikiPagePath path = PathParser.parse(expandedPath);
        if (path == null) {
            return true;
        }
        WikiPage start = path.isRelativePath() ? this.page.getParent() : this.page;
        return !start.getPageCrawler().pageExists(path);
    }

    private WikiPageProperty getSymLinkProperty(WikiPageProperties properties) {
        WikiPageProperty symLinks = properties.getProperty("SymbolicLinks");
        if (symLinks == null) {
            symLinks = properties.set("SymbolicLinks");
        }
        return symLinks;
    }
}

