/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testrunner;

import fitnesse.testrunner.Stoppable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RunningTestingTracker {
    public static final Logger LOG = Logger.getLogger(RunningTestingTracker.class.getName());
    private Map<String, Stoppable> processes = new ConcurrentHashMap<String, Stoppable>();
    private int nextTicketNumber = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateNextTicket() {
        int ticketNumber;
        RunningTestingTracker runningTestingTracker = this;
        synchronized (runningTestingTracker) {
            ticketNumber = this.nextTicketNumber++;
        }
        return Integer.toString(ticketNumber);
    }

    public synchronized String addStartedProcess(String ticket, Stoppable process) {
        this.processes.put(ticket, process);
        return ticket;
    }

    public synchronized void removeEndedProcess(String stopId) {
        this.processes.remove(stopId);
    }

    public String stopAllProcesses() {
        int count = 0;
        for (Stoppable process : this.processes.values()) {
            this.stopProcess(process);
            ++count;
        }
        return "Stopped " + Integer.toString(count) + " test(s) or suite(s)";
    }

    public String stopProcess(String ticket) {
        Stoppable process = this.processes.get(ticket);
        if (process != null) {
            this.stopProcess(process);
            return "Stopped 1 test or suite";
        }
        return "Could not find test or suite to stop";
    }

    private void stopProcess(Stoppable process) {
        try {
            process.stop();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Unable to stop test system", e);
        }
    }
}

