/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim;

import fitnesse.slim.JavaSlimFactory;
import fitnesse.slim.SlimService;
import fitnesse.testsystems.Descriptor;
import fitnesse.testsystems.MockCommandRunner;
import fitnesse.testsystems.slim.SlimClientBuilder;
import fitnesse.testsystems.slim.SlimCommandRunningClient;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InProcessSlimClientBuilder
extends SlimClientBuilder {
    private static final Logger LOG = Logger.getLogger(InProcessSlimClientBuilder.class.getName());

    public InProcessSlimClientBuilder(Descriptor descriptor) {
        super(descriptor);
    }

    @Override
    public SlimCommandRunningClient build() throws IOException {
        MockCommandRunner commandRunner = new MockCommandRunner(this.getExecutionLogListener());
        String[] slimArguments = this.buildArguments();
        this.createSlimService(slimArguments);
        return new SlimCommandRunningClient(commandRunner, this.determineSlimHost(), this.getSlimPort(), this.determineTimeout(), this.getSlimVersion(), this.determineSSL(), this.determineHostSSLParameterClass());
    }

    @Override
    protected int getNextSlimPort() {
        return 0;
    }

    void createSlimService(String[] args) throws IOException {
        while (!this.tryCreateSlimService(args)) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                LOG.log(Level.WARNING, "Interrupted while waiting for Slim server to come on line", e);
            }
        }
    }

    private boolean tryCreateSlimService(String[] args) throws IOException {
        try {
            SlimService.Options options = SlimService.parseCommandLine(args);
            int actualPort = SlimService.startWithFactoryAsync(JavaSlimFactory.createJavaSlimFactory(options), options);
            this.setSlimPort(actualPort);
            return true;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Could not start async Slim service", e);
            return false;
        }
    }
}

