/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fit.FixtureLoader;
import fit.FixtureName;
import fitnesse.testsystems.slim.tables.SlimTable;
import fitnesse.testsystems.slim.tables.SlimTableFactory;
import fitnesse.wikitext.parser.HtmlTranslator;
import fitnesse.wikitext.parser.HtmlWriter;
import fitnesse.wikitext.parser.Maybe;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.SymbolTypeDecorator;
import fitnesse.wikitext.parser.Table;
import fitnesse.wikitext.parser.Translator;
import java.util.ArrayList;
import java.util.List;

public class ColoredSlimTable
extends SymbolTypeDecorator {
    private List<String> secondRowTitleClasses = new ArrayList<String>();

    public ColoredSlimTable(Table baseSymbolType) {
        super("Table", baseSymbolType);
        this.secondRowTitleClasses.add("fitnesse.testsystems.slim.tables.DecisionTable");
        this.secondRowTitleClasses.add("fitnesse.testsystems.slim.tables.DynamicDecisionTable");
        this.secondRowTitleClasses.add("fitnesse.testsystems.slim.tables.QueryTable");
        this.secondRowTitleClasses.add("fitnesse.testsystems.slim.tables.SubsetQueryTable");
        this.secondRowTitleClasses.add("fitnesse.testsystems.slim.tables.OrderedQueryTable");
    }

    @Override
    public String toTarget(Translator translator, Symbol symbol) {
        HtmlWriter writer = new HtmlWriter();
        writer.startTag("table");
        if (symbol.hasProperty("class")) {
            writer.putAttribute("class", symbol.getProperty("class"));
        }
        int longestRow = ((Table)this.baseSymbolType).longestRow(symbol);
        int rowCount = 0;
        boolean isImportFixture = false;
        boolean colorTable = false;
        boolean isFirstColumnTitle = false;
        boolean isSecondRowTitle = false;
        boolean isCommentFixture = false;
        for (Symbol child : symbol.getChildren()) {
            writer.startTag("tr");
            if (++rowCount == 1 && symbol.hasProperty("hideFirst")) {
                writer.putAttribute("class", "hidden");
            }
            int extraColumnSpan = longestRow - ((Table)this.baseSymbolType).rowLength(child);
            int column = 1;
            for (Symbol grandChild : child.getChildren()) {
                String body = ((Table)this.baseSymbolType).translateCellBody(translator, grandChild);
                if (rowCount == 1 && column == 1) {
                    SlimTableFactory sf = new SlimTableFactory();
                    String tableName = body;
                    Class<? extends SlimTable> slimTableClazz = sf.getTableType(tableName);
                    if (slimTableClazz != null) {
                        colorTable = true;
                        if (this.secondRowTitleClasses.contains(slimTableClazz.getName())) {
                            isSecondRowTitle = true;
                        } else if (slimTableClazz.getName().equals("fitnesse.testsystems.slim.tables.ImportTable")) {
                            isImportFixture = true;
                        } else if (slimTableClazz.getName().equals("fitnesse.testsystems.slim.tables.ScriptTable") || slimTableClazz.getName().equals("fitnesse.testsystems.slim.tables.ScenarioTable")) {
                            isFirstColumnTitle = true;
                        }
                    }
                    if (!colorTable) {
                        List<String> potentialClasses = new FixtureName(tableName).getPotentialFixtureClassNames(FixtureLoader.instance().fixturePathElements);
                        for (String potentialClass : potentialClasses) {
                            try {
                                Class<?> fixtureClazz = Class.forName(potentialClass);
                                if (fixtureClazz == null) continue;
                                colorTable = true;
                                isSecondRowTitle = true;
                            }
                            catch (ClassNotFoundException cnfe) {
                            }
                            catch (NoClassDefFoundError ncdfe) {}
                        }
                    }
                }
                if (colorTable && column == 1) {
                    if (isImportFixture) {
                        FixtureLoader.instance().addPackageToPath(body);
                    }
                    if (rowCount == 1) {
                        writer.putAttribute("class", "slimRowTitle");
                    } else if (isSecondRowTitle && rowCount == 2) {
                        writer.putAttribute("class", "slimRowTitle");
                    } else if (isFirstColumnTitle) {
                        byte[] bodyBytes = body.getBytes();
                        int sum = 0;
                        for (byte b : bodyBytes) {
                            sum += b;
                        }
                        writer.putAttribute("class", "slimRowColor" + sum % 10);
                    } else if (!isCommentFixture) {
                        writer.putAttribute("class", "slimRowColor" + rowCount % 2);
                    }
                }
                writer.startTag("td");
                if (extraColumnSpan > 0 && column == ((Table)this.baseSymbolType).rowLength(child)) {
                    writer.putAttribute("colspan", Integer.toString(extraColumnSpan + 1));
                }
                writer.putText(body);
                writer.endTag();
                ++column;
            }
            writer.endTag();
        }
        writer.endTag();
        return writer.toHtml();
    }

    @Override
    public SymbolType isApplicable(Translator translator) {
        Maybe<String> testSystem = Maybe.noString;
        if (translator instanceof HtmlTranslator) {
            testSystem = ((HtmlTranslator)translator).getParsingPage().findVariable("TEST_SYSTEM");
        }
        if (testSystem.isNothing() || !testSystem.getValue().equals("slim")) {
            return this.baseSymbolType;
        }
        return this;
    }
}

