/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.xebialabs.deployit.security.SecurityServiceLocator;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;

public class LoginPermissionVoter
implements AccessDecisionVoter<Object> {
    private static final Logger logger = LoggerFactory.getLogger(LoginPermissionVoter.class);

    public boolean supports(ConfigAttribute attribute) {
        return true;
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }

    public int vote(Authentication authentication, Object object, Collection<ConfigAttribute> attributes) {
        logger.debug("Checking authorization for [{}]", (Object)authentication.getName());
        if (SecurityServiceLocator.getPermissionEnforcer().hasPermission(authentication, PlatformPermissions.LOGIN)) {
            logger.debug("User [{}] is authorized for login", (Object)authentication.getName());
            return 1;
        }
        logger.error("User [{}] is not allowed to login to XL Deploy.", (Object)authentication.getName());
        return -1;
    }
}

