/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.http.ChunkedDataProvider;
import fitnesse.http.ChunkedResponse;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.responders.ErrorResponder;
import fitnesse.responders.NotFoundResponder;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ChunkingResponder
implements Responder,
ChunkedDataProvider {
    private final Logger LOG = Logger.getLogger(ChunkingResponder.class.getName());
    protected WikiPage root;
    public WikiPage page;
    protected WikiPagePath path;
    protected Request request;
    protected ChunkedResponse response;
    protected FitNesseContext context;
    private boolean dontChunk = false;

    @Override
    public Response makeResponse(FitNesseContext context, Request request) {
        this.context = context;
        this.request = request;
        this.root = context.getRootPage(request.getMap());
        String format = request.getInput("format");
        this.response = new ChunkedResponse(format, this);
        if (this.dontChunk || request.hasInput("nochunk")) {
            this.response.turnOffChunking();
        }
        this.getRequestedPage(request);
        if (this.page == null && this.shouldRespondWith404()) {
            return this.pageNotFoundResponse(context, request);
        }
        return this.response;
    }

    public void turnOffChunking() {
        this.dontChunk = true;
    }

    private void getRequestedPage(Request request) {
        this.path = PathParser.parse(request.getResource());
        this.page = this.getPageCrawler().getPage(this.path);
    }

    protected PageCrawler getPageCrawler() {
        return this.root.getPageCrawler();
    }

    private Response pageNotFoundResponse(FitNesseContext context, Request request) {
        return new NotFoundResponder().makeResponse(context, request);
    }

    protected boolean shouldRespondWith404() {
        return true;
    }

    @Override
    public void startSending() {
        try {
            this.doSending();
        }
        catch (SocketException e) {
            this.LOG.log(Level.WARNING, "Socket Exception at: " + System.currentTimeMillis(), e);
        }
        catch (Exception e) {
            this.addExceptionAndCloseResponse(e);
        }
    }

    private void addExceptionAndCloseResponse(Exception e) {
        try {
            this.response.add(ErrorResponder.makeExceptionString(e));
            this.response.closeAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getRenderedPath() {
        if (this.path != null) {
            return PathParser.render(this.path);
        }
        return this.request.getResource();
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    protected abstract void doSending() throws Exception;
}

