/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.files;

import fitnesse.FitNesseContext;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.ErrorResponder;
import fitnesse.responders.files.FileResponder;
import fitnesse.wiki.fs.FileVersion;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

public class CreateDirectoryResponder
implements SecureResponder {
    @Override
    public Response makeResponse(FitNesseContext context, Request request) throws IOException {
        SimpleResponse response = new SimpleResponse();
        String resource = request.getResource();
        String dirname = request.getInput("dirname");
        final File file = new File(new File(context.getRootPagePath(), resource), dirname);
        if (!FileResponder.isInFilesDirectory(new File(context.getRootPagePath()), file)) {
            return new ErrorResponder("Invalid path: " + file.getName()).makeResponse(context, request);
        }
        final String user = request.getAuthorizationUsername();
        if (!file.exists()) {
            context.versionsController.addDirectory(new FileVersion(){

                @Override
                public File getFile() {
                    return file;
                }

                @Override
                public InputStream getContent() throws IOException {
                    return null;
                }

                @Override
                public String getAuthor() {
                    return user != null ? user : "";
                }

                @Override
                public Date getLastModificationTime() {
                    return new Date();
                }
            });
        }
        response.redirect(context.contextRoot, resource);
        return response;
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }
}

