/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.MethodExecutionResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VariableStore {
    public static final Pattern SYMBOL_PATTERN = Pattern.compile("\\$([A-Za-z]\\w*)");
    private Map<String, MethodExecutionResult> variables = new HashMap<String, MethodExecutionResult>();
    private Matcher symbolMatcher;

    public void setSymbol(String name, MethodExecutionResult value) {
        this.variables.put(name, value);
    }

    public Object getStored(String nameWithDollar) {
        if (nameWithDollar == null || !nameWithDollar.startsWith("$")) {
            return null;
        }
        String name = nameWithDollar.substring(1);
        if (!this.variables.containsKey(name)) {
            return null;
        }
        return this.variables.get(name).getObject();
    }

    private boolean containsValueFor(String nameWithDollar) {
        return nameWithDollar != null && nameWithDollar.startsWith("$") && this.variables.containsKey(nameWithDollar.substring(1));
    }

    public Object[] replaceSymbols(Object[] args) {
        Object[] result = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            result[i] = this.replaceSymbol(args[i]);
        }
        return result;
    }

    private List<Object> replaceSymbolsInList(List<Object> objects) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object object : objects) {
            result.add(this.replaceSymbol(object));
        }
        return result;
    }

    private Object replaceSymbol(Object object) {
        if (object instanceof List) {
            return this.replaceSymbolsInList((List)object);
        }
        if (this.containsValueFor((String)object)) {
            return this.getStored((String)object);
        }
        return this.replaceSymbolsInString((String)object);
    }

    public String replaceSymbolsInString(String arg) {
        int startingPosition = 0;
        while (!"".equals(arg) && null != arg) {
            this.symbolMatcher = SYMBOL_PATTERN.matcher(arg);
            if (!this.symbolMatcher.find(startingPosition)) break;
            String symbolName = this.symbolMatcher.group(1);
            arg = this.replaceSymbolInArg(arg, symbolName);
            startingPosition = this.symbolMatcher.start(1);
        }
        return arg;
    }

    private String replaceSymbolInArg(String arg, String symbolName) {
        if (this.variables.containsKey(symbolName)) {
            String replacement = "null";
            MethodExecutionResult value = this.variables.get(symbolName);
            if (value != null) {
                replacement = ((Object)value).toString();
            }
            arg = arg.substring(0, this.symbolMatcher.start()) + replacement + arg.substring(this.symbolMatcher.end());
        }
        return arg;
    }
}

