/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.api.internal;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.domain.Executable;
import com.xebialabs.xltest.repository.TestSpecificationRepository;
import com.xebialabs.xltest.serialize.ExecutionProgressEventWriter;
import com.xebialabs.xltest.service.ExecutableAlreadyRunningException;
import com.xebialabs.xltest.service.ExecutionProgressEvent;
import com.xebialabs.xltest.service.TestExecutionStateHolder;
import com.xebialabs.xltest.service.TestSpecificationExecutor;
import com.xebialabs.xltest.view.ExecutionParameterRequest;
import com.xebialabs.xltest.view.ExecutionParameters;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/api/internal/execute")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@NoCache
public class ExecuteController {
    private static final Logger LOG = LoggerFactory.getLogger(ExecuteController.class);
    private final RepositoryService repository;
    private final AutowireCapableBeanFactory beanFactory;
    private final TestSpecificationRepository testSpecificationRepository;
    private final TestSpecificationExecutor testSpecificationExecutor;
    private final TestExecutionStateHolder testExecutionStateHolder;

    @Autowired
    public ExecuteController(RepositoryService repository, TestSpecificationRepository testSpecificationRepository, TestSpecificationExecutor testSpecificationExecutor, AutowireCapableBeanFactory beanFactory, TestExecutionStateHolder testExecutionStateHolder) {
        this.repository = repository;
        this.testSpecificationRepository = testSpecificationRepository;
        this.testSpecificationExecutor = testSpecificationExecutor;
        this.beanFactory = beanFactory;
        this.testExecutionStateHolder = testExecutionStateHolder;
    }

    @POST
    @Path(value="{testSpecificationId}")
    public Response execute(@PathParam(value="testSpecificationId") String testSpecificationId, ExecutionParameters executionParameters) throws Exception {
        BaseTestSpecification objectRead = this.testSpecificationRepository.get(testSpecificationId);
        if (!(objectRead instanceof Executable)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{\"error\":\"TestSpecification not executable\"}").build();
        }
        Executable executableTestSpecification = (Executable)((Object)objectRead);
        ExecutionParameterRequest request = executableTestSpecification.toExecutionParameterRequest();
        if (!executionParameters.satisfies(request)) {
            LOG.debug("Unsufficient parameters. Returning Unprocessable Entity (422)");
            return Response.status((int)422).entity((Object)request).build();
        }
        if (executableTestSpecification.updateExecutionProperties(executionParameters.getCommandLine(), this.fetchHost(executionParameters))) {
            this.repository.update(new ConfigurationItem[]{objectRead});
        }
        this.beanFactory.autowireBean((Object)executableTestSpecification);
        Map<String, Object> parameters = executionParameters.getParameters();
        try {
            UUID runId = this.testSpecificationExecutor.execute(executableTestSpecification, parameters);
            return Response.ok((Object)("{ \"taskId\": \"" + runId + "\"}")).build();
        }
        catch (ExecutableAlreadyRunningException re) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)re.getMessage()).build();
        }
    }

    @GET
    @Path(value="/status/{testSpecificationId}")
    public Response getSpecificationStatus(@PathParam(value="testSpecificationId") String testSpecificationId) throws Exception {
        BaseTestSpecification testSpecification = this.testSpecificationRepository.get(testSpecificationId);
        List<ExecutionProgressEvent> progressEvents = this.testExecutionStateHolder.getProgress(Lists.newArrayList((Object[])new BaseTestSpecification[]{testSpecification}));
        if (progressEvents.size() == 1) {
            ExecutionProgressEvent progressEvent = progressEvents.get(0);
            return Response.ok((Object)new ExecutionProgressEventWriter().serialize(progressEvent)).build();
        }
        return Response.ok().build();
    }

    private Host fetchHost(ExecutionParameters executionParameters) {
        if (executionParameters.getHostId() == null) {
            return null;
        }
        return (Host)this.repository.read(executionParameters.getHostId());
    }

    @DELETE
    @Path(value="{testSpecificationId}")
    public void execute(@PathParam(value="testSpecificationId") String testSpecificationId) {
        this.testSpecificationExecutor.cancel(testSpecificationId);
    }
}

