/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.repository;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.xltest.Synthetic;
import com.xebialabs.xltest.domain.Dashboard;
import com.xebialabs.xltest.domain.DashboardTile;
import com.xebialabs.xltest.domain.Report;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class DashboardRepository {
    private static final Logger LOG = LoggerFactory.getLogger((String)DashboardRepository.class.getName());
    private static final int MIN_AUTO_RELOAD_INTERVAL = 3;
    private RepositoryService repository;

    @Autowired
    public DashboardRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public Dashboard getById(String id) {
        Dashboard dashboard = (Dashboard)this.repository.read(id);
        this.setShowcaseLabel(dashboard);
        return dashboard;
    }

    public void create(BaseConfigurationItem item) {
        LOG.info("create dashboard item={}", (Object)item);
        Dashboard dashboard = (Dashboard)item;
        dashboard.setAutoReloadInterval(Math.max(3, dashboard.getAutoReloadInterval()));
        this.generateDashboardId(dashboard);
        this.generateTileIds(dashboard);
        ArrayList<BaseConfigurationItem> items = new ArrayList<BaseConfigurationItem>();
        items.add(dashboard);
        items.addAll(dashboard.getDashboardTiles());
        this.repository.create(items.toArray(new ConfigurationItem[items.size()]));
    }

    private void generateDashboardId(Dashboard dashboard) {
        dashboard.setId(Synthetic.createNewDashboardId());
    }

    private void generateTileIds(Dashboard dashboard) {
        for (DashboardTile tile : dashboard.getDashboardTiles()) {
            tile.setId(Synthetic.createNewDashboardTileId(dashboard));
        }
    }

    public List<DashboardTile> findDashboardTilesBySpecificationName(String testSpecificationName) {
        List<Dashboard> all = this.getAll();
        ArrayList<DashboardTile> tiles = new ArrayList<DashboardTile>();
        for (Dashboard dashboard : all) {
            List<DashboardTile> dashboardTiles = dashboard.getDashboardTiles();
            for (DashboardTile dashboardTile : dashboardTiles) {
                if (!dashboardTile.getTestSpecification().getName().equals(testSpecificationName)) continue;
                tiles.add(this.enhanceTileWithReportProperties(dashboardTile));
            }
        }
        return tiles;
    }

    public List<Dashboard> getAll() {
        SearchParameters query = new SearchParameters();
        query.setType(Type.valueOf((String)Synthetic.DASHBOARD.name));
        return this.repository.listEntities(query);
    }

    public List<Dashboard> getAllEnhancedWithReportProperties() {
        List<Dashboard> dashboards = this.getAll();
        this.enhanceTilesWithReportProperties(dashboards);
        return dashboards;
    }

    private void enhanceTilesWithReportProperties(List<Dashboard> dashboards) {
        for (Dashboard dashboard : dashboards) {
            for (DashboardTile tile : dashboard.getDashboardTiles()) {
                this.enhanceTileWithReportProperties(tile);
            }
        }
    }

    private DashboardTile enhanceTileWithReportProperties(DashboardTile tile) {
        if (tile.getReportType() != null) {
            Report report = (Report)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)tile.getReportType())).newInstance(UUID.randomUUID().toString());
            tile.setReportIcon(report.getIconName());
            tile.setReportName(report.getUserFriendlyDescription());
        }
        return tile;
    }

    public void deleteTile(DashboardTile tileToRemove) {
        Dashboard dashboard = this.getById(tileToRemove.getDashboardId());
        ArrayList<DashboardTile> listWithoutTileToRemove = new ArrayList<DashboardTile>();
        for (DashboardTile tile : dashboard.getDashboardTiles()) {
            if (tile.getId().equals(tileToRemove.getId())) continue;
            listWithoutTileToRemove.add(tile);
        }
        dashboard.setDashboardTiles(listWithoutTileToRemove);
        this.update(tileToRemove.getDashboardId(), dashboard);
    }

    public void deleteDashboardTilesBySpecificationName(String specificationName) {
        List<DashboardTile> dashboardTiles = this.findDashboardTilesBySpecificationName(specificationName);
        for (DashboardTile dashboardTile : dashboardTiles) {
            this.deleteTile(dashboardTile);
        }
    }

    public void update(String dashboardId, Dashboard updatedDashboard) {
        Dashboard original = (Dashboard)this.repository.read(dashboardId);
        this.createIdsForTilesWhichHasNoID(updatedDashboard);
        ArrayList<String> idsToDelete = new ArrayList<String>();
        for (DashboardTile dashboardTile : original.getDashboardTiles()) {
            final String originalDashboardTileId = dashboardTile.getId();
            Collection foundTiles = Collections2.filter(updatedDashboard.getDashboardTiles(), (Predicate)new Predicate<DashboardTile>(){

                public boolean apply(DashboardTile input) {
                    return input.getId().equals(originalDashboardTileId);
                }
            });
            if (!foundTiles.isEmpty()) continue;
            idsToDelete.add(originalDashboardTileId);
        }
        if (!idsToDelete.isEmpty()) {
            LOG.debug("Going to delete dashboardTiles: " + idsToDelete);
            this.repository.delete(idsToDelete.toArray(new String[idsToDelete.size()]));
        }
        ArrayList<BaseConfigurationItem> items = new ArrayList<BaseConfigurationItem>();
        LOG.debug("Going to save/update dashboardTiles: {}", updatedDashboard.getDashboardTiles());
        LOG.debug("Going to save dashboard: {}", (Object)updatedDashboard);
        items.add(updatedDashboard);
        items.addAll(this.populateIdsInTilesCreatedByFrontend(updatedDashboard.getDashboardTiles(), updatedDashboard));
        this.repository.createOrUpdate(items.toArray(new ConfigurationItem[items.size()]));
    }

    private List<DashboardTile> createIdsForTilesWhichHasNoID(Dashboard dashboard) {
        List<DashboardTile> dashboardTiles = dashboard.getDashboardTiles();
        for (DashboardTile tile : dashboardTiles) {
            if (!StringUtils.isEmpty((CharSequence)tile.getId())) continue;
            tile.setId(Synthetic.createNewDashboardTileId(dashboard));
        }
        return dashboardTiles;
    }

    private void setShowcaseLabel(Dashboard dashboard) {
        for (DashboardTile dashboardTile : dashboard.getDashboardTiles()) {
            Boolean showCaseData;
            if (dashboardTile.getTestSpecification() == null || !dashboardTile.getTestSpecification().hasProperty("showCaseData") || (showCaseData = (Boolean)dashboardTile.getTestSpecification().getProperty("showCaseData")) == null) continue;
            dashboardTile.setShowCaseData(showCaseData);
        }
    }

    private List<DashboardTile> populateIdsInTilesCreatedByFrontend(List<DashboardTile> tiles, Dashboard dashboard) {
        for (DashboardTile tile : tiles) {
            if (!tile.getName().contains(tile.getTitle())) continue;
            tile.setId(Synthetic.createNewDashboardTileId(dashboard));
        }
        return tiles;
    }
}

